/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.util.ProjectUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class ProjectNameValidationService
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!event.property().definition().equals(NewLiferayPluginProjectOp.PROP_FINAL_PROJECT_NAME)) {
                    ProjectNameValidationService.this.refresh();
                }
            }
        };
        this.op().attach((Listener)this.listener, "*");
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        NewLiferayPluginProjectOp op = this.op();
        String currentProjectName = (String)op.getProjectName().content();
        if (currentProjectName != null) {
            IStatus nameStatus = CoreUtil.getWorkspace().validateName(currentProjectName, 4);
            if (!nameStatus.isOK()) {
                retval = StatusBridge.create((IStatus)nameStatus);
            } else if (CoreUtil.getProject((String)currentProjectName).exists()) {
                retval = Status.createErrorStatus((String)"A project with that name already exists.");
            } else if (this.isAntProject(op) && this.isSuffixOnly(currentProjectName)) {
                retval = Status.createErrorStatus((String)"A project name cannot only be a type suffix.");
            } else if (!this.hasValidDisplayName(currentProjectName)) {
                retval = Status.createErrorStatus((String)"The project name is invalid.");
            } else {
                org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)op.getLocation().content(true);
                if (currentProjectName != null && currentProjectLocation != null) {
                    String currentPath = currentProjectLocation.toOSString();
                    IPath osPath = Path.fromOSString((String)currentPath);
                    IStatus projectStatus = ((ILiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(currentProjectName, osPath);
                    if (!projectStatus.isOK()) {
                        retval = StatusBridge.create((IStatus)projectStatus);
                    }
                }
            }
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        this.op().detach((Listener)this.listener, "*");
    }

    private boolean hasValidDisplayName(String currentProjectName) {
        String currentDisplayName = ProjectUtil.convertToDisplayName(currentProjectName);
        return !CoreUtil.isNullOrEmpty((String)currentDisplayName);
    }

    private boolean isAntProject(NewLiferayPluginProjectOp op) {
        return "ant".equals(((ILiferayProjectProvider)op.getProjectProvider().content()).getShortName());
    }

    private boolean isSuffixOnly(String currentProjectName) {
        PluginType[] pluginTypeArray = PluginType.values();
        int n = pluginTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginType type = pluginTypeArray[n2];
            if (!type.equals((Object)PluginType.servicebuilder) && ("-" + type.name()).equals(currentProjectName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

