/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ProjectProviderValidationService
extends ValidationService {
    private Listener listener = null;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<Event>(){

            protected void handleTypedEvent(Event event) {
                ProjectProviderValidationService.this.refresh();
            }
        };
        NewLiferayPluginProjectOp op = this.op();
        op.getPluginsSDKName().attach(this.listener);
        op.getRuntimeName().attach(this.listener);
        op.getUseSdkLocation().attach(this.listener);
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        NewLiferayPluginProjectOp op = this.op();
        if ("ant".equals(((ILiferayProjectProvider)op.getProjectProvider().content()).getShortName()) && !((Boolean)op.getUseSdkLocation().content()).booleanValue() && !NewLiferayPluginProjectOpMethods.canUseCustomLocation(op)) {
            retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support using Eclipse workspace as base for project location.  Please configure a higher version.");
        }
        Status sdkNameStatus = op.getPluginsSDKName().validation();
        if (retval.ok() && !sdkNameStatus.ok()) {
            retval = sdkNameStatus;
        } else {
            Status runtimeNameStatus = op.getRuntimeName().validation();
            if (retval.ok() && !runtimeNameStatus.ok()) {
                retval = runtimeNameStatus;
            }
        }
        return retval;
    }

    public void dispose() {
        NewLiferayPluginProjectOp op = this.op();
        op.getUseSdkLocation().detach(this.listener);
        op.getRuntimeName().detach(this.listener);
        op.getPluginsSDKName().detach(this.listener);
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

