/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class SDKPluginFacetUtil {
    public static final IProjectFacet[] LIFERAY_FACETS = new IProjectFacet[]{IPluginFacetConstants.LIFERAY_PORTLET_PROJECT_FACET, IPluginFacetConstants.LIFERAY_HOOK_PROJECT_FACET, IPluginFacetConstants.LIFERAY_EXT_PROJECT_FACET, IPluginFacetConstants.LIFERAY_LAYOUTTPL_PROJECT_FACET, IPluginFacetConstants.LIFERAY_THEME_PROJECT_FACET};

    private static void addDefaultWebXml(IFacetedProjectWorkingCopy fpjwc, IDataModel dm) throws CoreException {
        File webXml;
        IPath webinfPath = fpjwc.getProjectLocation().append("docroot/WEB-INF");
        if (ProjectUtil.isExtProject(fpjwc.getProject()) || fpjwc.getProjectLocation().lastSegment().endsWith("-ext")) {
            fpjwc.getProjectLocation().append("docroot/WEB-INF/ext-web/docroot");
        }
        if (webinfPath.toFile().exists() && !(webXml = webinfPath.append("web.xml").toFile()).exists()) {
            ProjectUtil.setGenerateDD(dm, false);
            ProjectUtil.createDefaultWebXml(webXml, fpjwc.getProjectName());
            IProject project = fpjwc.getProject();
            if (project != null) {
                try {
                    project.refreshLocal(2, null);
                }
                catch (Exception e) {
                    LiferayProjectCore.logError((Throwable)e);
                }
            }
        }
    }

    public static void configureJavaFacet(IFacetedProjectWorkingCopy fpjwc, IProjectFacet requiredFacet, IPreset preset, ProjectRecord projectRecord) {
        IFacetedProject.Action action = fpjwc.getProjectFacetAction(requiredFacet);
        if (action == null) {
            return;
        }
        Object config = action.getConfig();
        if (!(config instanceof JavaFacetInstallConfig)) {
            return;
        }
        JavaFacetInstallConfig javaConfig = (JavaFacetInstallConfig)config;
        IDataModel dm = (IDataModel)Platform.getAdapterManager().getAdapter(config, IDataModel.class);
        String presetId = preset.getId();
        if (presetId.contains("portlet")) {
            javaConfig.setSourceFolder((IPath)new Path("docroot/WEB-INF/src"));
            javaConfig.setDefaultOutputFolder((IPath)new Path("docroot/WEB-INF/classes"));
            dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", "docroot/WEB-INF/src");
            dm.setStringProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", "docroot/WEB-INF/classes");
        } else if (presetId.contains("hook")) {
            javaConfig.setSourceFolder((IPath)new Path("docroot/WEB-INF/src"));
            javaConfig.setDefaultOutputFolder((IPath)new Path("docroot/WEB-INF/classes"));
            dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", "docroot/WEB-INF/src");
            dm.setStringProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", "docroot/WEB-INF/classes");
        } else if (presetId.contains("layouttpl")) {
            SDKPluginFacetUtil.removeSrcFolders(dm, javaConfig);
        } else if (presetId.contains("theme")) {
            IPath projectPath = projectRecord.getProjectLocation();
            IPath existingSrcFolder = projectPath.append("docroot/WEB-INF/src");
            if (existingSrcFolder.toFile().exists()) {
                javaConfig.setSourceFolder((IPath)new Path("docroot/WEB-INF/src"));
                javaConfig.setDefaultOutputFolder((IPath)new Path("docroot/WEB-INF/classes"));
                dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", "docroot/WEB-INF/src");
                dm.setStringProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", "docroot/WEB-INF/classes");
            } else {
                SDKPluginFacetUtil.removeSrcFolders(dm, javaConfig);
            }
        }
    }

    public static void configureLiferayFacet(IFacetedProjectWorkingCopy fpjwc, IProjectFacet requiredFacet, String sdkLocation) {
        IFacetedProject.Action action = fpjwc.getProjectFacetAction(requiredFacet);
        if (action != null) {
            Object config = action.getConfig();
            IDataModel dm = (IDataModel)config;
            dm.setProperty("IPluginProjectDataModelProperties.LIFERAY_SDK_NAME", (Object)SDKPluginFacetUtil.getSDKName(sdkLocation));
        }
    }

    public static void configureLiferayFacet(IFacetedProjectWorkingCopy fpjwc, IProjectFacetVersion requiredFacetVersion, String sdkLocation) {
        SDKPluginFacetUtil.configureLiferayFacet(fpjwc, requiredFacetVersion.getProjectFacet(), sdkLocation);
    }

    public static void configureProjectAsPlugin(IFacetedProjectWorkingCopy fpjwc, IRuntime runtime, String pluginType, String sdkLocation, ProjectRecord projectRecord) throws CoreException {
        fpjwc.setTargetedRuntimes(Collections.emptySet());
        if (runtime != null) {
            fpjwc.setTargetedRuntimes(Collections.singleton(runtime));
        }
        fpjwc.setPrimaryRuntime(runtime);
        IFacetedProjectTemplate template = SDKPluginFacetUtil.getLiferayTemplateForProject(pluginType);
        IPreset preset = SDKPluginFacetUtil.getLiferayPresetForProject(pluginType);
        if (preset == null) {
            throw new CoreException(LiferayProjectCore.createErrorStatus((String)NLS.bind((String)Msgs.noFacetPreset, (Object)fpjwc.getProjectName())));
        }
        Set currentProjectFacetVersions = fpjwc.getProjectFacets();
        Set requiredFacets = template.getFixedProjectFacets();
        for (IProjectFacet requiredFacet : requiredFacets) {
            boolean hasRequiredFacet = false;
            for (IProjectFacetVersion currentFacetVersion : currentProjectFacetVersions) {
                if (!currentFacetVersion.getProjectFacet().equals(requiredFacet)) continue;
                boolean supports = runtime.supports(currentFacetVersion);
                if (supports) {
                    hasRequiredFacet = true;
                    break;
                }
                fpjwc.removeProjectFacet(currentFacetVersion);
                break;
            }
            if (!hasRequiredFacet) {
                IProjectFacetVersion requiredFacetVersion = SDKPluginFacetUtil.getRequiredFacetVersionFromPreset(requiredFacet, preset);
                if (requiredFacetVersion == null) continue;
                fpjwc.addProjectFacet(requiredFacetVersion);
                if (ProjectUtil.isJavaFacet(requiredFacetVersion)) {
                    SDKPluginFacetUtil.configureJavaFacet(fpjwc, requiredFacetVersion.getProjectFacet(), preset, projectRecord);
                    continue;
                }
                if (ProjectUtil.isLiferayFacet(requiredFacetVersion)) {
                    SDKPluginFacetUtil.configureLiferayFacet(fpjwc, requiredFacetVersion, sdkLocation);
                    continue;
                }
                if (!ProjectUtil.isDynamicWebFacet(requiredFacetVersion)) continue;
                SDKPluginFacetUtil.configureWebFacet(fpjwc, requiredFacetVersion.getProjectFacet(), preset);
                continue;
            }
            if (ProjectUtil.isJavaFacet(requiredFacet)) {
                SDKPluginFacetUtil.configureJavaFacet(fpjwc, requiredFacet, preset, projectRecord);
                continue;
            }
            if (ProjectUtil.isLiferayFacet(requiredFacet)) {
                SDKPluginFacetUtil.configureLiferayFacet(fpjwc, requiredFacet, sdkLocation);
                continue;
            }
            if (!ProjectUtil.isDynamicWebFacet(requiredFacet)) continue;
            SDKPluginFacetUtil.configureWebFacet(fpjwc, requiredFacet, preset);
        }
    }

    public static void configureWebFacet(IFacetedProjectWorkingCopy fpjwc, IProjectFacet requiredFacet, IPreset preset) throws CoreException {
        IFacetedProject.Action action = fpjwc.getProjectFacetAction(requiredFacet);
        if (action != null) {
            IDataModel dm = (IDataModel)action.getConfig();
            if (preset.getId().contains("portlet")) {
                dm.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "docroot");
                dm.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", "docroot/WEB-INF/src");
                SDKPluginFacetUtil.addDefaultWebXml(fpjwc, dm);
            } else if (preset.getId().contains("hook")) {
                dm.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "docroot");
                dm.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", "docroot/WEB-INF/src");
                SDKPluginFacetUtil.addDefaultWebXml(fpjwc, dm);
            } else if (preset.getId().contains("ext")) {
                dm.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "docroot/WEB-INF/ext-web/docroot");
                dm.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", "docroot/WEB-INF/src");
                SDKPluginFacetUtil.addDefaultWebXml(fpjwc, dm);
            } else if (preset.getId().contains("layouttpl")) {
                dm.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "docroot");
                dm.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", "docroot/WEB-INF/src");
                ProjectUtil.setGenerateDD(dm, false);
            } else if (preset.getId().contains("theme")) {
                dm.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", "docroot");
                ProjectUtil.setGenerateDD(dm, false);
            }
        }
    }

    public static IPreset getLiferayPresetForProject(String pluginType) {
        IPreset preset = null;
        if ("portlet".equals(pluginType) || "servicebuilder".equals(pluginType)) {
            preset = ProjectFacetsManager.getPreset((String)"liferay.portlet.preset");
        } else if ("hook".equals(pluginType)) {
            preset = ProjectFacetsManager.getPreset((String)"liferay.hook.preset");
        } else if ("ext".equals(pluginType)) {
            preset = ProjectFacetsManager.getPreset((String)"liferay.ext.preset");
        } else if ("layouttpl".equals(pluginType)) {
            preset = ProjectFacetsManager.getPreset((String)"liferay.layouttpl.preset");
        } else if ("theme".equals(pluginType)) {
            preset = ProjectFacetsManager.getPreset((String)"liferay.theme.preset");
        }
        return preset;
    }

    public static IFacetedProjectTemplate getLiferayTemplateForProject(String pluginType) {
        IFacetedProjectTemplate template = null;
        if ("portlet".equals(pluginType) || "servicebuilder".equals(pluginType)) {
            template = ProjectFacetsManager.getTemplate((String)"liferay.portlet.template");
        } else if ("hook".equals(pluginType)) {
            template = ProjectFacetsManager.getTemplate((String)"liferay.hook.template");
        } else if ("ext".equals(pluginType)) {
            template = ProjectFacetsManager.getTemplate((String)"liferay.ext.template");
        } else if ("layouttpl".equals(pluginType)) {
            template = ProjectFacetsManager.getTemplate((String)"liferay.layouttpl.template");
        } else if ("theme".equals(pluginType)) {
            template = ProjectFacetsManager.getTemplate((String)"liferay.theme.template");
        }
        return template;
    }

    private static IProjectFacetVersion getRequiredFacetVersionFromPreset(IProjectFacet requiredFacet, IPreset preset) {
        Set facets = preset.getProjectFacets();
        for (IProjectFacetVersion facet : facets) {
            if (!facet.getProjectFacet().equals(requiredFacet)) continue;
            return facet;
        }
        return null;
    }

    public static String getSDKName(String sdkLocation) {
        Path sdkLocationPath = new Path(sdkLocation);
        SDK sdk = SDKManager.getInstance().getSDK((IPath)sdkLocationPath);
        String sdkName = null;
        if (sdk != null) {
            sdkName = sdk.getName();
        } else {
            sdk = SDKUtil.createSDKFromLocation((IPath)sdkLocationPath);
            SDKManager.getInstance().addSDK(sdk);
            sdkName = sdk.getName();
        }
        return sdkName;
    }

    private static void removeSrcFolders(IDataModel dm, JavaFacetInstallConfig javaConfig) {
        dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", null);
        dm.setStringProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", "docroot/WEB-INF/classes");
        List srcFolders = javaConfig.getSourceFolders();
        if (!CoreUtil.isNullOrEmpty((List)srcFolders)) {
            for (IPath srcFolder : srcFolders) {
                javaConfig.removeSourceFolder(srcFolder);
            }
        }
    }

    private static class Msgs
    extends NLS {
        public static String noFacetPreset;

        static {
            Msgs.initializeMessages((String)SDKPluginFacetUtil.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

