/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.AbstractScanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceScanner
extends AbstractScanner {
    protected final IResource resource;
    protected final List<String> includedDirectories = new ArrayList<String>();
    protected final List<String> includedFiles = new ArrayList<String>();

    public ResourceScanner(IResource resource) {
        this.resource = resource;
    }

    public String[] getIncludedDirectories() {
        return this.includedDirectories.toArray(new String[this.includedDirectories.size()]);
    }

    public String[] getIncludedFiles() {
        return this.includedFiles.toArray(new String[this.includedFiles.size()]);
    }

    public void scan() {
        try {
            this.setupDefaultFilters();
            this.setupMatchPatterns();
            this.scanResource();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void scanResource() throws CoreException {
        this.resource.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                String relpath = ResourceScanner.this.getRelativePath(resource);
                if (ResourceScanner.this.isIncluded(relpath) && !ResourceScanner.this.isExcluded(relpath)) {
                    if (resource instanceof IContainer) {
                        ResourceScanner.this.includedDirectories.add(relpath);
                    } else {
                        ResourceScanner.this.includedFiles.add(relpath);
                    }
                    return true;
                }
                if (resource instanceof IFolder) {
                    return ResourceScanner.this.couldHoldIncluded(relpath);
                }
                return false;
            }
        });
    }

    protected String getRelativePath(IResource resource) {
        return resource.getFullPath().removeFirstSegments(this.resource.getFullPath().segmentCount()).toOSString();
    }

    public File getBasedir() {
        return this.resource.getLocation().toFile();
    }
}

