/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.server.tomcat.core.LiferayTomcatServerBehavior;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.PublishHelper;

public class LiferayPublishOperation
extends PublishOperation {
    private static final String LIFERAY_WEB_XML_PATH = "WEB-INF/liferay-web.xml";
    private static final String WEB_XML_PATH = "WEB-INF/web.xml";
    protected LiferayTomcatServerBehavior server;
    protected IModule[] module;
    protected int kind;
    protected int deltaKind;
    private PublishHelper helper;

    public LiferayPublishOperation(LiferayTomcatServerBehavior server, int kind, IModule[] module, int deltaKind) {
        super(Msgs.publishServer, Msgs.publishWebModule);
        this.server = server;
        this.module = module;
        this.kind = kind;
        this.deltaKind = deltaKind;
        IPath base = server.getRuntimeBaseDirectory();
        this.helper = base != null ? new PublishHelper(base.append("temp").toFile()) : new PublishHelper(null);
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        ArrayList status = new ArrayList();
        if (this.module.length == 1) {
            if (!ServerUtil.isExtProject((IProject)this.module[0].getProject())) {
                this.publishDir(this.module[0], status, monitor);
            }
        } else {
            Properties p = this.server.loadModulePublishLocations();
            IWebModule webModule = (IWebModule)this.module[0].loadAdapter(IWebModule.class, monitor);
            String childURI = null;
            if (webModule != null) {
                childURI = webModule.getURI(this.module[1]);
            }
            IJ2EEModule childModule = (IJ2EEModule)this.module[1].loadAdapter(IJ2EEModule.class, monitor);
            boolean isBinary = false;
            if (childModule != null) {
                isBinary = childModule.isBinary();
            }
            if (isBinary) {
                this.publishArchiveModule(childURI, p, status, monitor);
            } else {
                this.publishJar(childURI, p, status, monitor);
            }
            this.server.saveModulePublishLocations(p);
        }
        LiferayPublishOperation.throwException(status);
        this.server.setModulePublishState2(this.module, 1);
    }

    private void publishDir(IModule module2, List status, IProgressMonitor monitor) throws CoreException {
        int n;
        boolean serverStopped;
        final IPath path = this.server.getModuleDeployDirectory(module2);
        if (this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File f = path.toFile();
            if (f.exists()) {
                try {
                    File autoDeployDir;
                    File autoDeployFile;
                    IPath baseDir = this.server.getRuntimeBaseDirectory();
                    IPath serverXml = baseDir.append("conf").append("server.xml");
                    ServerInstance oldInstance = TomcatVersionHelper.getCatalinaServerInstance((IPath)serverXml, null, null);
                    IPath contextDir = oldInstance.getContextXmlDirectory(baseDir.append("conf"));
                    String contextFileName = String.valueOf(path.lastSegment()) + ".xml";
                    File contextFile = contextDir.append(contextFileName).toFile();
                    if (contextFile.exists()) {
                        contextFile.delete();
                    }
                    if ((autoDeployFile = new File(autoDeployDir = baseDir.append(this.server.getLiferayTomcatServer().getAutoDeployDirectory()).toFile(), contextFileName)).exists()) {
                        autoDeployFile.delete();
                    }
                }
                catch (Exception e) {
                    LiferayTomcatPlugin.logError("Could not delete context xml file.", e);
                }
                IStatus[] stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                LiferayPublishOperation.addArrayToList(status, stat);
            }
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        IPath baseDir = this.server.getTomcatServer().getRuntimeBaseDirectory();
        Path autoDeployDir = new Path(this.server.getLiferayTomcatServer().getAutoDeployDirectory());
        boolean bl = serverStopped = this.server.getServer().getServerState() == 4;
        if (this.kind == 4 || this.kind == 2) {
            IModuleResource[] mr = this.server.getResources(this.module);
            IStatus[] stat = this.helper.publishFull(mr, path, monitor);
            LiferayPublishOperation.addArrayToList(status, stat);
            this.clearWebXmlDescriptors(module2.getProject(), path, monitor);
            this.server.moveContextToAutoDeployDir(module2, path, baseDir, (IPath)autoDeployDir, true, serverStopped);
            return;
        }
        IModuleResourceDelta[] delta = this.server.getPublishedResourceDelta(this.module);
        File[] antiDirs = new File[]{};
        try {
            File tempDir = this.server.getLiferayTomcatServer().getTomcatRuntime().getRuntime().getLocation().append("temp").toFile();
            antiDirs = tempDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(path.lastSegment());
                }
            });
        }
        catch (Exception exception) {}
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.helper.publishDelta(delta[i], path, monitor);
            File[] fileArray = antiDirs;
            int n2 = antiDirs.length;
            n = 0;
            while (n < n2) {
                File antiDir = fileArray[n];
                if (antiDir.exists()) {
                    try {
                        this.helper.publishDelta(delta[i], (IPath)new Path(antiDir.getCanonicalPath()), monitor);
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
            LiferayPublishOperation.addArrayToList(status, stat);
            ++i;
        }
        String[] paths = new String[]{WEB_XML_PATH, "WEB-INF/portlet.xml", "WEB-INF/liferay-portlet.xml", "WEB-INF/liferay-display.xml", "WEB-INF/liferay-look-and-feel.xml", "WEB-INF/liferay-hook.xml", "WEB-INF/liferay-layout-templates.xml", "WEB-INF/liferay-plugin-package.properties", "WEB-INF/liferay-plugin-package.xml", "WEB-INF/server-config.wsdd"};
        IModuleResourceDelta[] iModuleResourceDeltaArray = delta;
        n = delta.length;
        int n3 = 0;
        while (n3 < n) {
            IModuleResourceDelta del = iModuleResourceDeltaArray[n3];
            if (CoreUtil.containsMember((IModuleResourceDelta)del, (String[])paths) || this.isHookProjectDelta(del)) {
                this.clearWebXmlDescriptors(module2.getProject(), path, monitor);
                this.server.moveContextToAutoDeployDir(module2, path, baseDir, (IPath)autoDeployDir, true, serverStopped);
                break;
            }
            ++n3;
        }
    }

    private void clearWebXmlDescriptors(IProject project, IPath path, IProgressMonitor monitor) {
        IModuleResource webXmlRes = this.getWebXmlFile(project, path);
        if (webXmlRes != null) {
            this.helper.publishToPath(new IModuleResource[]{webXmlRes}, path.append(WEB_XML_PATH), monitor);
        } else {
            File webXmlFile = path.append(WEB_XML_PATH).toFile();
            File liferayWebXmlFile = path.append(LIFERAY_WEB_XML_PATH).toFile();
            if (webXmlFile.exists() && !webXmlFile.delete()) {
                ProjectUtil.createDefaultWebXml((File)webXmlFile, (String)project.getName());
            }
            if (liferayWebXmlFile.exists() && !liferayWebXmlFile.delete()) {
                ProjectUtil.createDefaultWebXml((File)liferayWebXmlFile, (String)project.getName());
            }
        }
    }

    private boolean isHookProjectDelta(IModuleResourceDelta del) {
        IResource resource = (IResource)del.getModuleResource().getAdapter(IResource.class);
        if (resource != null) {
            return ProjectUtil.isHookProject((IProject)resource.getProject());
        }
        return false;
    }

    private IModuleResource getWebXmlFile(IProject project, IPath modelDeployDirectory) {
        IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)project);
        if (webappRoot != null) {
            IContainer[] iContainerArray = webappRoot.getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile webXml;
                IContainer container = iContainerArray[n2];
                if (container != null && container.exists() && (webXml = container.getFile((IPath)new Path(WEB_XML_PATH))).exists()) {
                    return new ModuleFile(webXml, webXml.getName(), modelDeployDirectory.append(WEB_XML_PATH));
                }
                ++n2;
            }
        }
        return null;
    }

    private void publishJar(String jarURI, Properties p, List status, IProgressMonitor monitor) throws CoreException {
        IModuleResourceDelta[] delta;
        IPath jarPath;
        IPath path = this.server.getModuleDeployDirectory(this.module[0]);
        boolean moving = false;
        String oldURI = (String)p.get(this.module[1].getId());
        if (oldURI != null && jarURI != null) {
            boolean bl = moving = !oldURI.equals(jarURI);
        }
        if (jarURI == null) {
            jarURI = "WEB-INF/lib/" + this.module[1].getName() + ".jar";
        }
        IPath oldJarPath = jarPath = path.append(jarURI);
        if (oldURI != null) {
            oldJarPath = path.append(oldURI);
        }
        path = jarPath.removeLastSegments(1);
        if (moving || this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File file = oldJarPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            p.remove(this.module[1].getId());
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (!(moving || this.kind == 4 || this.kind == 2 || (delta = this.server.getPublishedResourceDelta(this.module)) != null && delta.length != 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this.server.getResources(this.module);
        IStatus[] stat = this.helper.publishZip(mr, jarPath, monitor);
        LiferayPublishOperation.addArrayToList(status, stat);
        p.put(this.module[1].getId(), jarURI);
    }

    private void publishArchiveModule(String jarURI, Properties p, List status, IProgressMonitor monitor) {
        IModuleResourceDelta[] delta;
        IPath jarPath;
        IPath path = this.server.getModuleDeployDirectory(this.module[0]);
        boolean moving = false;
        String oldURI = (String)p.get(this.module[1].getId());
        if (oldURI != null && jarURI != null) {
            boolean bl = moving = !oldURI.equals(jarURI);
        }
        if (jarURI == null) {
            jarURI = "WEB-INF/lib/" + this.module[1].getName();
        }
        IPath oldJarPath = jarPath = path.append(jarURI);
        if (oldURI != null) {
            oldJarPath = path.append(oldURI);
        }
        path = jarPath.removeLastSegments(1);
        if (moving || this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File file = oldJarPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            p.remove(this.module[1].getId());
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (!(moving || this.kind == 4 || this.kind == 2 || (delta = this.server.getPublishedResourceDelta(this.module)) != null && delta.length != 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this.server.getResources(this.module);
        IStatus[] stat = this.helper.publishToPath(mr, jarPath, monitor);
        LiferayPublishOperation.addArrayToList(status, stat);
        p.put(this.module[1].getId(), jarURI);
    }

    protected static void throwException(List status) throws CoreException {
        if (status == null || status.size() == 0) {
            return;
        }
        if (status.size() == 1) {
            IStatus status2 = (IStatus)status.get(0);
            throw new CoreException(status2);
        }
        IStatus[] children = new IStatus[status.size()];
        status.toArray(children);
        String message = Msgs.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, children, message, null);
        throw new CoreException((IStatus)status2);
    }

    protected static void addArrayToList(List list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }

    private static class Msgs
    extends NLS {
        public static String errorPublish;
        public static String publishServer;
        public static String publishWebModule;

        static {
            Msgs.initializeMessages((String)LiferayPublishOperation.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

