/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.debug.core.LiferayDebugCore;
import com.liferay.ide.debug.core.fm.FMDebugTarget;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.PortalSourceLookupDirector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jst.server.tomcat.core.internal.TomcatLaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.Version;

public class LiferayTomcatLaunchConfigDelegate
extends TomcatLaunchConfigurationDelegate {
    private static final String STOP_SERVER = "stop-server";
    private static final String FALSE = "false";
    private static final String FM_PARAMS = " -Dfreemarker.debug.password={0} -Dfreemarker.debug.port={1}";
    private String saveLaunchMode;
    private String fmDebugPort;

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String retval = super.getVMArguments(configuration);
        String stopServer = configuration.getAttribute(STOP_SERVER, FALSE);
        if ("debug".equals(this.saveLaunchMode) && FALSE.equals(stopServer)) {
            try {
                IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
                ILiferayRuntime liferayRuntime = (ILiferayRuntime)server.getRuntime().loadAdapter(ILiferayRuntime.class, null);
                Version version = new Version(liferayRuntime.getPortalVersion());
                if (CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V620) >= 0) {
                    if (this.fmDebugPort != null) {
                        retval = String.valueOf(retval) + NLS.bind((String)FM_PARAMS, (Object)LiferayDebugCore.getPreference((String)"fm-debug-password"), (Object)this.fmDebugPort);
                    } else {
                        LiferayDebugCore.logError((String)"The freemarker debug port is invalid.");
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if ("debug".equals(mode)) {
            PortalSourceLookupDirector sourceLocator = new PortalSourceLookupDirector(configuration, "com.liferay.ide.server.tomcat.portalSourcePathComputer");
            sourceLocator.configureLaunch(launch);
        }
        this.fmDebugPort = this.getValidatedDebugPort();
        this.saveLaunchMode = mode;
        super.launch(configuration, mode, launch, monitor);
        this.saveLaunchMode = null;
        String stopServer = configuration.getAttribute(STOP_SERVER, FALSE);
        if ("debug".equals(mode) && FALSE.equals(stopServer)) {
            if (this.fmDebugPort != null) {
                launch.setAttribute("fm-debug-port", this.fmDebugPort);
                this.fmDebugPort = null;
                IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
                FMDebugTarget target = new FMDebugTarget(server.getHost(), launch, launch.getProcesses()[0]);
                launch.addDebugTarget((IDebugTarget)target);
            } else {
                LiferayDebugCore.logError((String)"Launch freemarker port is invalid.");
            }
        }
    }

    private String getValidatedDebugPort() {
        int port = Integer.parseInt(LiferayDebugCore.getPreference((String)"fm-debug-port"));
        if (port < 1025 || port > 65535) {
            port = 1025;
        }
        while (port <= 65535) {
            try {
                ServerSocket server = new ServerSocket();
                server.bind(new InetSocketAddress(port));
                server.close();
                break;
            }
            catch (IOException iOException) {
                ++port;
            }
        }
        if (port <= 65535) {
            return String.valueOf(port);
        }
        return null;
    }
}

