/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.cmd;

import com.liferay.ide.layouttpl.core.model.ModelElement;
import com.liferay.ide.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.layouttpl.ui.model.PortletLayout;
import org.eclipse.gef.commands.Command;
import org.eclipse.osgi.util.NLS;

public class PortletColumnDeleteCommand
extends Command {
    protected PortletColumn adjustedColumn = null;
    protected int adjustedColumnWeight = 0;
    protected final PortletColumn child;
    protected LayoutTplDiagram diagram = null;
    protected final PortletLayout parent;
    protected int parentIndex = 0;
    protected boolean wasRemoved;

    public PortletColumnDeleteCommand(PortletLayout parent, PortletColumn child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Msgs.portletColumnDeleted);
        this.parent = parent;
        this.child = child;
    }

    public boolean canUndo() {
        return this.wasRemoved;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        this.wasRemoved = this.parent.removeColumn(this.child);
        int columnsNum = this.parent.getColumns().size();
        if (columnsNum == 0) {
            this.diagram = (LayoutTplDiagram)this.parent.getParent();
            this.parentIndex = this.diagram.getRows().indexOf((Object)this.parent);
            this.diagram.removeChild((ModelElement)this.parent);
        } else if (columnsNum == 1) {
            this.adjustedColumn = (PortletColumn)((Object)this.parent.getColumns().get(0));
            this.adjustedColumnWeight = this.adjustedColumn.getWeight() + this.child.getWeight();
            this.adjustedColumn.setWeight(100);
        } else {
            int childIndex = this.child.getNumId() - ((PortletColumn)((Object)this.parent.getColumns().get(0))).getNumId();
            int adjustedColumnIndex = 0;
            adjustedColumnIndex = childIndex < (columnsNum + 1) / 2 ? childIndex : childIndex - 1;
            this.adjustedColumn = (PortletColumn)((Object)this.parent.getColumns().get(adjustedColumnIndex));
            this.adjustedColumn.setWeight(this.adjustedColumn.getWeight() + this.child.getWeight());
            this.adjustedColumnWeight = this.adjustedColumn.getWeight();
        }
    }

    public void undo() {
        if (this.adjustedColumn != null) {
            this.adjustedColumn.setWeight(this.adjustedColumnWeight - this.child.getWeight());
        }
        if (!this.parent.getColumns().isEmpty()) {
            int childIndex = this.child.getNumId() - ((PortletColumn)((Object)this.parent.getColumns().get(0))).getNumId();
            this.parent.addColumn(this.child, childIndex);
        } else {
            this.parent.addColumn(this.child);
        }
        if (this.diagram != null) {
            this.diagram.addRow(this.parent, this.parentIndex);
        }
    }

    private static class Msgs
    extends NLS {
        public static String portletColumnDeleted;

        static {
            Msgs.initializeMessages((String)PortletColumnDeleteCommand.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

