/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.cmd;

import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.core.model.PortletRowLayoutElement;
import com.liferay.ide.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.layouttpl.ui.model.PortletLayout;
import org.eclipse.gef.commands.Command;
import org.eclipse.osgi.util.NLS;

public class PortletLayoutCreateCommand
extends Command {
    protected PortletRowLayoutElement rowLayout;
    protected LayoutConstraint layoutConstraint;
    protected PortletLayout newLayout;

    public PortletLayoutCreateCommand(PortletLayout newLayout, PortletRowLayoutElement rowLayout, LayoutConstraint constraint) {
        this.newLayout = newLayout;
        this.rowLayout = rowLayout;
        this.layoutConstraint = constraint;
        this.setLabel(Msgs.portletRowAdded);
    }

    public boolean canExecute() {
        return this.newLayout != null && this.rowLayout != null && this.layoutConstraint != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.newLayout.getColumns().size() == 0) {
            PortletColumn newColumn = new PortletColumn(100);
            this.newLayout.addColumn(newColumn);
        }
        this.rowLayout.addRow((PortletLayoutElement)this.newLayout, this.layoutConstraint.newRowIndex);
    }

    public void undo() {
        this.rowLayout.removeRow((PortletLayoutElement)this.newLayout);
    }

    private static class Msgs
    extends NLS {
        public static String portletRowAdded;

        static {
            Msgs.initializeMessages((String)PortletLayoutCreateCommand.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

