/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.editor;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.LayoutTplCore;
import com.liferay.ide.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplEditor;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplMultiOutlinePage;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplMultiPageEditorActionBarContributor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.osgi.framework.Version;

public class LayoutTplMultiPageEditor
extends MultiPageEditorPart
implements ISelectionListener {
    protected static final int SOURCE_PAGE_INDEX = 1;
    protected static final int VISUAL_PAGE_INDEX = 0;
    protected int lastPageIndex = -1;
    protected LayoutTplMultiOutlinePage multiOutlinePage;
    protected PropertyListener propertyListener;
    protected StructuredTextEditor sourceEditor;
    protected LayoutTplEditor visualEditor;
    protected boolean visualEditorSupported;

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void doSave(IProgressMonitor monitor) {
        int activePage = this.getActivePage();
        if (activePage == 0) {
            this.visualEditor.doSave(monitor);
        }
        this.sourceEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.sourceEditor.doSaveAs();
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.multiOutlinePage == null && this.sourceEditor != null && this.visualEditor != null) {
                IContentOutlinePage sourceOutlinePage = (IContentOutlinePage)this.sourceEditor.getAdapter(adapter);
                IContentOutlinePage visualOutlinePage = (IContentOutlinePage)this.visualEditor.getAdapter(adapter);
                if (sourceOutlinePage != null && visualOutlinePage != null) {
                    LayoutTplMultiOutlinePage outlinePage;
                    this.multiOutlinePage = outlinePage = new LayoutTplMultiOutlinePage(this, sourceOutlinePage, visualOutlinePage);
                }
            }
            return this.multiOutlinePage;
        }
        result = super.getAdapter(adapter);
        if (result == null) {
            if (adapter.equals(IGotoMarker.class)) {
                result = new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        LayoutTplMultiPageEditor.this.gotoMarker(marker);
                    }
                };
            } else {
                if (this.sourceEditor != null) {
                    result = this.sourceEditor.getAdapter(adapter);
                }
                if (result == null && this.visualEditor != null) {
                    result = this.visualEditor.getAdapter(adapter);
                }
            }
        }
        return result;
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public LayoutTplEditor getVisualEditor() {
        return this.visualEditor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public boolean isSaveAsAllowed() {
        return this.sourceEditor != null && this.sourceEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.isDirty()) {
            return true;
        }
        if (this.sourceEditor != null) {
            return this.sourceEditor.isSaveOnCloseNeeded();
        }
        return this.isDirty();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.visualEditor.updateActions();
        }
    }

    protected void addSourcePage() throws PartInitException {
        int index = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
        this.setPageText(index, Msgs.source);
        this.firePropertyChange(1);
        this.sourceEditor.getTextViewer().addTextInputListener((ITextInputListener)new TextInputListener());
    }

    protected void connectVisualPage() {
        this.visualEditor.setInput(this.getEditorInput());
    }

    protected void createAndAddVisualPage() throws PartInitException {
        LayoutTplEditor editor = this.createVisualEditor();
        int index = this.addPage((IEditorPart)editor, this.getEditorInput());
        this.setPageText(index, Msgs.visual);
    }

    protected void createPages() {
        try {
            this.createSourcePage();
            this.createAndAddVisualPage();
            this.addSourcePage();
            this.connectVisualPage();
            IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
            if (contributor instanceof MultiPageEditorActionBarContributor) {
                ((MultiPageEditorActionBarContributor)contributor).setActiveEditor((IEditorPart)this);
            }
            int activePageIndex = 0;
            activePageIndex = this.visualEditorSupported ? this.getPreferenceStore().getInt("LAST_ACTIVE_PAGE") : 1;
            if (activePageIndex >= 0 && activePageIndex < this.getPageCount()) {
                this.setActivePage(activePageIndex);
            } else {
                this.setActivePage(0);
            }
        }
        catch (PartInitException ex) {
            LayoutTplCore.logError((Exception)((Object)ex));
            throw new RuntimeException(ex);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.sourceEditor ? new MultiPageEditorSite(this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = LayoutTplMultiPageEditor.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof LayoutTplMultiPageEditorActionBarContributor) {
                    contributor = ((LayoutTplMultiPageEditorActionBarContributor)multiContributor).sourceEditorContributor;
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForHTML.ContentTypeID_HTML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    protected void createSourcePage() throws PartInitException {
        this.sourceEditor = new StructuredTextEditor();
        this.sourceEditor.setEditorPart((IEditorPart)this);
        if (this.propertyListener == null) {
            this.propertyListener = new PropertyListener();
        }
        this.sourceEditor.addPropertyListener((IPropertyListener)this.propertyListener);
    }

    protected LayoutTplEditor createVisualEditor() {
        this.visualEditor = new LayoutTplEditor(this.sourceEditor, this.visualEditorSupported);
        return this.visualEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        return LayoutTplUI.getDefault().getPreferenceStore();
    }

    protected void pageChange(int newPageIndex) {
        if (this.lastPageIndex == 0 && newPageIndex == 1) {
            if (this.visualEditor.isDirty()) {
                this.visualEditor.refreshSourceModel();
            }
        } else if (this.lastPageIndex == 1 && newPageIndex == 0) {
            this.visualEditor.refreshVisualModel();
        }
        super.pageChange(newPageIndex);
        if (this.multiOutlinePage != null) {
            this.multiOutlinePage.refreshOutline();
        }
        this.lastPageIndex = newPageIndex;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        this.setVisualEditorSupported();
    }

    void gotoMarker(IMarker marker) {
        this.setActivePage(1);
        IDE.gotoMarker((IEditorPart)this.sourceEditor, (IMarker)marker);
    }

    protected void setVisualEditorSupported() {
        this.visualEditorSupported = true;
        try {
            IFile editorFile;
            ILiferayProject lproj;
            IEditorInput editorInput = this.getEditorInput();
            IPath path = null;
            if (editorInput instanceof IFileEditorInput) {
                path = ((IFileEditorInput)editorInput).getFile().getFullPath();
            } else if (editorInput instanceof FileStoreEditorInput) {
                path = new Path(((FileStoreEditorInput)editorInput).getURI().getPath());
            }
            if (path != null && CoreUtil.compareVersions((Version)ILiferayConstants.V620, (Version)new Version((lproj = LiferayCore.create((Object)(editorFile = CoreUtil.getWorkspaceRoot().getFile(path)).getProject())).getPortalVersion())) <= 0) {
                this.visualEditorSupported = false;
            }
        }
        catch (Exception exception) {}
    }

    private static class Msgs
    extends NLS {
        public static String source;
        public static String visual;

        static {
            Msgs.initializeMessages((String)LayoutTplMultiPageEditor.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    class PropertyListener
    implements IPropertyListener {
        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        }
    }
}

