/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.parts;

import com.liferay.ide.layouttpl.ui.draw2d.ColumnFigure;
import com.liferay.ide.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.layouttpl.ui.parts.PortletLayoutEditPart;
import com.liferay.ide.layouttpl.ui.parts.PortletRowLayoutEditPart;
import com.liferay.ide.layouttpl.ui.policies.PortletColumnComponentEditPolicy;
import com.liferay.ide.layouttpl.ui.policies.PortletColumnLayoutEditPolicy;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;

public class PortletColumnEditPart
extends PortletRowLayoutEditPart {
    public static final int COLUMN_MARGIN = 10;

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PortletColumnComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PortletColumnLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        Figure f;
        if (this.getModelChildren().isEmpty()) {
            f = this.createFigureForModel();
            f.setOpaque(true);
        } else {
            f = super.createFigure();
        }
        f.setBackgroundColor(new Color(null, 232, 232, 232));
        return f;
    }

    protected Figure createFigureForModel() {
        if (this.getModel() instanceof PortletColumn) {
            ColumnFigure rect = new ColumnFigure();
            rect.setCornerDimensions(new Dimension(20, 20));
            return rect;
        }
        throw new IllegalArgumentException();
    }

    public GridData createGridData() {
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = this.getCastedParent().getDefaultColumnHeight();
        return gd;
    }

    protected Panel createPanel() {
        return new Panel(){

            protected void paintFigure(Graphics graphics) {
                Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
                --r.width;
                --r.height;
                graphics.drawRoundRectangle(r, 20, 20);
                --r.width;
                --r.height;
                ++r.x;
                ++r.y;
                graphics.fillRoundRectangle(r, 20, 20);
            }
        };
    }

    public PortletColumn getCastedModel() {
        return (PortletColumn)((Object)this.getModel());
    }

    public PortletLayoutEditPart getCastedParent() {
        return (PortletLayoutEditPart)this.getParent();
    }

    public int getMargin() {
        return 10;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("PortletColumn.weight".equals(prop)) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Object constraint = ((GraphicalEditPart)this.getParent()).getFigure().getLayoutManager().getConstraint(this.getFigure());
        GridData gd = null;
        if (constraint instanceof GridData) {
            gd = (GridData)constraint;
            if (gd.heightHint == -1) {
                gd.heightHint = this.getCastedParent().getDefaultColumnHeight();
            }
        } else {
            gd = this.createGridData();
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)gd);
        int columnWeight = this.getCastedModel().getWeight();
        if (columnWeight == -1) {
            columnWeight = 100;
        }
        if (this.getFigure() instanceof ColumnFigure) {
            ((ColumnFigure)this.getFigure()).setText(String.valueOf(columnWeight) + "%");
        }
    }
}

