/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.parts;

import com.liferay.ide.layouttpl.core.model.ModelElement;
import com.liferay.ide.layouttpl.core.model.PortletRowLayoutElement;
import com.liferay.ide.layouttpl.ui.parts.BaseGraphicalEditPart;
import com.liferay.ide.layouttpl.ui.parts.PortletColumnEditPart;
import com.liferay.ide.layouttpl.ui.parts.PortletLayoutEditPart;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRowLayoutEditPart
extends BaseGraphicalEditPart {
    public static final int DEFAULT_COLUMN_HEIGHT = -1;
    protected Panel panel;
    protected boolean shouldUpdateConstraints = false;

    protected void configurePanel(Panel panel) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        panel.setLayoutManager((LayoutManager)gridLayout);
        panel.setBorder((Border)new MarginBorder(this.getMargin()));
        panel.addLayoutListener(new LayoutListener(){

            public void invalidate(IFigure container) {
                PortletRowLayoutEditPart.this.shouldUpdateConstraints = true;
            }

            public boolean layout(IFigure container) {
                return false;
            }

            public void postLayout(IFigure container) {
                if (PortletRowLayoutEditPart.this.shouldUpdateConstraints) {
                    PortletRowLayoutEditPart.this.updateColumnConstraints();
                }
            }

            public void remove(IFigure child) {
            }

            public void setConstraint(IFigure child, Object constraint) {
            }
        });
    }

    protected IFigure createFigure() {
        this.panel = this.createPanel();
        this.configurePanel(this.panel);
        return this.panel;
    }

    protected Panel createPanel() {
        return new Panel();
    }

    protected PortletRowLayoutElement getCastedModel() {
        return (PortletRowLayoutElement)this.getModel();
    }

    public int getContainerWidth() {
        if (this.panel != null) {
            return this.panel.getSize().width - this.getMargin() * 2;
        }
        return 0;
    }

    public abstract int getMargin();

    protected List<ModelElement> getModelChildren() {
        return this.getCastedModel().getRows();
    }

    public int getPreferredColumnHeight() {
        int retval = -1;
        int numRows = this.getRowPartsCount();
        if (numRows > 1) {
            Rectangle partBounds = this.getFigure().getBounds();
            if (partBounds.height > 0) {
                int computedColumnHeight;
                int partHeight = partBounds.height;
                int rowsHeight = partHeight - this.getMargin() * 2;
                int totalColumnsHeight = rowsHeight - this.getRowPartsCount() * 10 * 2;
                retval = computedColumnHeight = totalColumnsHeight / numRows;
            }
        }
        return retval;
    }

    protected int getRowPartsCount() {
        return this.getChildren().size();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("LayoutTplDiagram.RowAdded".equals(prop) || "LayoutTplDiagram.RowRemoved".equals(prop)) {
            this.refreshChildren();
            List rows = this.getChildren();
            if (rows.size() > 0) {
                for (Object row : rows) {
                    AbstractEditPart rowPart = (AbstractEditPart)row;
                    List cols = rowPart.getChildren();
                    if (cols.size() > 0) {
                        for (Object col : cols) {
                            ((AbstractEditPart)col).refresh();
                        }
                    }
                    ((AbstractEditPart)row).refresh();
                }
            }
            this.refreshVisuals();
        }
    }

    public void refresh() {
        super.refresh();
        if (this.getChildren() != null) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        List children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof AbstractEditPart)) continue;
            ((AbstractEditPart)child).refresh();
        }
    }

    protected void updateColumnConstraints() {
        try {
            try {
                for (Object row : this.getChildren()) {
                    PortletLayoutEditPart rowPart = (PortletLayoutEditPart)row;
                    for (Object col : ((EditPart)row).getChildren()) {
                        PortletColumnEditPart columnPart = (PortletColumnEditPart)col;
                        Object constraint = rowPart.getLayoutConstraint(columnPart, columnPart.getFigure());
                        if (!(constraint instanceof GridData)) continue;
                        GridData gd = (GridData)constraint;
                        int columnHeight = this.getPreferredColumnHeight();
                        if (columnHeight > 0) {
                            gd.heightHint = columnHeight;
                        } else {
                            gd.heightHint = -1;
                            gd.grabExcessVerticalSpace = true;
                        }
                        rowPart.setLayoutConstraint((EditPart)columnPart, columnPart.getFigure(), gd);
                    }
                }
            }
            catch (Exception exception) {
                this.shouldUpdateConstraints = false;
            }
        }
        finally {
            this.shouldUpdateConstraints = false;
        }
    }
}

