/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.layouttpl.ui.util.LayoutTplUIUtil;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.wizard.LiferayDataModelWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class NewLayoutTplWizardPage
extends LiferayDataModelWizardPage
implements INewLayoutTplDataModelProperties {
    protected Text id;
    protected Text name;
    protected String projectName;
    protected Combo projectNameCombo;
    protected Label projectNameLabel;
    protected Text templateFile;
    protected Text thumbnailFile;
    protected Text wapTemplateFile;

    public NewLayoutTplWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName, Msgs.createLayoutTemplate, LayoutTplUI.imageDescriptorFromPlugin((String)"com.liferay.ide.layouttpl.ui", (String)"/icons/wizban/layout_template_wiz.png"));
        this.setDescription(Msgs.createLiferayLayoutTemplate);
    }

    protected void createProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText("Layout plugin project:");
        this.projectNameLabel.setLayoutData((Object)new GridData());
        this.projectNameCombo = new Combo(parent, 2056);
        GridData data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.projectNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        String initialProjectName = this.initializeProjectList(this.projectNameCombo, this.model);
        if (this.projectName == null && initialProjectName != null) {
            this.projectName = initialProjectName;
        }
    }

    protected void createTemplateInfoGroup(Composite parent) {
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)Msgs.name, (int)1);
        this.name = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.name, "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME", null);
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)Msgs.id, (int)1);
        this.id = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.id, "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID", null);
        SWTUtil.createLabel((Composite)parent, (String)"", (int)1);
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)Msgs.templateFile, (int)1);
        this.templateFile = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.templateFile, "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE", null);
        Button templateFileBrowse = SWTUtil.createPushButton((Composite)parent, (String)Msgs.browse, null);
        templateFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutTplWizardPage.this.handleFileBrowseButton(NewLayoutTplWizardPage.this.templateFile, Msgs.templateFileSelection, Msgs.chooseTemplateFile);
            }
        });
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)Msgs.wapTemplateFile, (int)1);
        this.wapTemplateFile = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.wapTemplateFile, "INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE", null);
        Button wapTemplateFileBrowse = SWTUtil.createPushButton((Composite)parent, (String)Msgs.browse, null);
        wapTemplateFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutTplWizardPage.this.handleFileBrowseButton(NewLayoutTplWizardPage.this.wapTemplateFile, Msgs.wapTemplateFileSelection, Msgs.chooseWAPTemplateFile);
            }
        });
        SWTUtil.createLabel((Composite)parent, (int)131072, (String)Msgs.thumbnailFile, (int)1);
        this.thumbnailFile = SWTUtil.createText((Composite)parent, (int)1);
        this.synchHelper.synchText(this.thumbnailFile, "INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE", null);
        Button thumbnailFileBrowse = SWTUtil.createPushButton((Composite)parent, (String)Msgs.browse, null);
        thumbnailFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLayoutTplWizardPage.this.handleFileBrowseButton(NewLayoutTplWizardPage.this.thumbnailFile, Msgs.wapTemplateFileSelection, Msgs.chooseThumbnailFile);
            }
        });
        this.synchHelper.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME".equals(event.getPropertyName()) || "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID".equals(event.getPropertyName())) {
                    NewLayoutTplWizardPage.this.synchHelper.synchAllUIWithModel();
                }
            }
        });
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topComposite = SWTUtil.createTopComposite((Composite)parent, (int)3);
        this.createProjectNameGroup(topComposite);
        SWTUtil.createSeparator((Composite)topComposite, (int)3);
        this.createTemplateInfoGroup(topComposite);
        return topComposite;
    }

    protected void enter() {
        super.enter();
        this.validatePage(true);
    }

    protected IVirtualFolder getDocroot() {
        return CoreUtil.getDocroot((String)this.getDataModel().getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IArtifactEditOperationDataModelProperties.PROJECT_NAME", "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME", "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID", "INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE", "INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE", "INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE"};
    }

    protected boolean isProjectValid(IProject project) {
        return LayoutTplUIUtil.isLayoutTplProject(project);
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String browse;
        public static String chooseTemplateFile;
        public static String chooseThumbnailFile;
        public static String chooseWAPTemplateFile;
        public static String createLayoutTemplate;
        public static String createLiferayLayoutTemplate;
        public static String id;
        public static String name;
        public static String templateFile;
        public static String templateFileSelection;
        public static String thumbnailFile;
        public static String wapTemplateFile;
        public static String wapTemplateFileSelection;

        static {
            Msgs.initializeMessages((String)NewLayoutTplWizardPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

