/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatConstants;
import com.liferay.ide.server.tomcat.core.LiferayTomcatServer;
import com.liferay.ide.server.tomcat.ui.command.SetAutoDeployDirectoryCommand;
import com.liferay.ide.server.tomcat.ui.command.SetAutoDeployIntervalCommand;
import com.liferay.ide.server.tomcat.ui.command.SetExternalPropertiesCommand;
import com.liferay.ide.server.tomcat.ui.command.SetMemoryArgsCommand;
import com.liferay.ide.server.tomcat.ui.command.SetUserTimezoneCommand;
import com.liferay.ide.server.util.ServerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class LiferayServerSettingsEditorSection
extends ServerEditorSection {
    protected Section section;
    protected LiferayTomcatServer tomcatServer;
    protected Hyperlink setDefault;
    protected boolean defaultDeployDirIsSet;
    protected Text memoryArgs;
    protected Text userTimezone;
    protected Text externalProperties;
    protected Text autoDeployDir;
    protected Button autoDeployDirBrowse;
    protected Button externalPropertiesBrowse;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected IPublishListener publishListener;
    protected IPath workspacePath;
    protected IPath defaultDeployPath;
    protected boolean allowRestrictedEditing;
    protected IPath tempDirPath;
    protected IPath installDirPath;
    protected Text autoDeployInterval;
    private static final String METADATADIR = ".metadata";

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (LiferayServerSettingsEditorSection.this.updating) {
                    return;
                }
                LiferayServerSettingsEditorSection.this.updating = true;
                if ("instanceDir".equals(event.getPropertyName()) || "testEnvironment".equals(event.getPropertyName())) {
                    LiferayServerSettingsEditorSection.this.updateServerDirButtons();
                    LiferayServerSettingsEditorSection.this.updateServerDirFields();
                    LiferayServerSettingsEditorSection.this.validate();
                } else if ("autoDeployDir".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    LiferayServerSettingsEditorSection.this.autoDeployDir.setText(s);
                    LiferayServerSettingsEditorSection.this.updateDefaultDeployLink();
                    LiferayServerSettingsEditorSection.this.validate();
                } else if ("autoDeployInterval".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    LiferayServerSettingsEditorSection.this.autoDeployInterval.setText(s);
                    LiferayServerSettingsEditorSection.this.updateDefaultDeployLink();
                    LiferayServerSettingsEditorSection.this.validate();
                } else if ("memoryArgs".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    LiferayServerSettingsEditorSection.this.memoryArgs.setText(s);
                    LiferayServerSettingsEditorSection.this.validate();
                } else if ("userTimezone".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    LiferayServerSettingsEditorSection.this.userTimezone.setText(s);
                    LiferayServerSettingsEditorSection.this.validate();
                } else if ("externalProperties".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    LiferayServerSettingsEditorSection.this.externalProperties.setText(s);
                    LiferayServerSettingsEditorSection.this.validate();
                }
                LiferayServerSettingsEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != LiferayServerSettingsEditorSection.this.allowRestrictedEditing) {
                    LiferayServerSettingsEditorSection.this.allowRestrictedEditing = flag;
                }
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Msgs.liferaySettings);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.teig0000");
        whs.setHelp((Control)this.section, "org.eclipse.jst.server.tomcat.ui.teig0000");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        GridData data = new GridData(1, 0x1000000, false, false);
        Label label = this.createLabel(toolkit, composite, Msgs.memoryArgsLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.memoryArgs = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        this.memoryArgs.setLayoutData((Object)data);
        this.memoryArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LiferayServerSettingsEditorSection.this.updating) {
                    return;
                }
                LiferayServerSettingsEditorSection.this.updating = true;
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetMemoryArgsCommand(LiferayServerSettingsEditorSection.this.tomcatServer, LiferayServerSettingsEditorSection.this.memoryArgs.getText().trim()));
                LiferayServerSettingsEditorSection.this.updating = false;
                LiferayServerSettingsEditorSection.this.validate();
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label = this.createLabel(toolkit, composite, Msgs.userTimezoneLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.userTimezone = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        this.userTimezone.setLayoutData((Object)data);
        this.userTimezone.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LiferayServerSettingsEditorSection.this.updating) {
                    return;
                }
                LiferayServerSettingsEditorSection.this.updating = true;
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetUserTimezoneCommand(LiferayServerSettingsEditorSection.this.tomcatServer, LiferayServerSettingsEditorSection.this.userTimezone.getText().trim()));
                LiferayServerSettingsEditorSection.this.updating = false;
                LiferayServerSettingsEditorSection.this.validate();
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label = this.createLabel(toolkit, composite, Msgs.externalPropertiesLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.externalProperties = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 150;
        this.externalProperties.setLayoutData((Object)data);
        this.externalProperties.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LiferayServerSettingsEditorSection.this.updating) {
                    return;
                }
                LiferayServerSettingsEditorSection.this.updating = true;
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(LiferayServerSettingsEditorSection.this.tomcatServer, LiferayServerSettingsEditorSection.this.externalProperties.getText().trim()));
                LiferayServerSettingsEditorSection.this.updating = false;
                LiferayServerSettingsEditorSection.this.validate();
            }
        });
        this.externalPropertiesBrowse = toolkit.createButton(composite, Msgs.editorBrowse, 8);
        this.externalPropertiesBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.externalPropertiesBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(LiferayServerSettingsEditorSection.this.externalPropertiesBrowse.getShell());
                dialog.setFilterPath(LiferayServerSettingsEditorSection.this.externalPropertiesBrowse.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null && !selectedFile.equals(LiferayServerSettingsEditorSection.this.externalPropertiesBrowse.getText())) {
                    LiferayServerSettingsEditorSection.this.updating = true;
                    LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(LiferayServerSettingsEditorSection.this.tomcatServer, selectedFile));
                    LiferayServerSettingsEditorSection.this.externalProperties.setText(selectedFile);
                    LiferayServerSettingsEditorSection.this.updating = false;
                    LiferayServerSettingsEditorSection.this.validate();
                }
            }
        });
        label = this.createLabel(toolkit, composite, Msgs.autoDeployPathLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.autoDeployDir = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        this.autoDeployDir.setLayoutData((Object)data);
        this.autoDeployDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LiferayServerSettingsEditorSection.this.updating) {
                    return;
                }
                LiferayServerSettingsEditorSection.this.updating = true;
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetAutoDeployDirectoryCommand(LiferayServerSettingsEditorSection.this.tomcatServer, LiferayServerSettingsEditorSection.this.autoDeployDir.getText().trim()));
                LiferayServerSettingsEditorSection.this.updateDefaultDeployLink();
                LiferayServerSettingsEditorSection.this.updating = false;
                LiferayServerSettingsEditorSection.this.validate();
            }
        });
        this.autoDeployDirBrowse = toolkit.createButton(composite, Msgs.editorBrowse, 8);
        this.autoDeployDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(LiferayServerSettingsEditorSection.this.autoDeployDir.getShell());
                dialog.setMessage(Msgs.serverEditorBrowseDeployMessage);
                dialog.setFilterPath(LiferayServerSettingsEditorSection.this.autoDeployDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.equals(LiferayServerSettingsEditorSection.this.autoDeployDir.getText())) {
                    LiferayServerSettingsEditorSection.this.updating = true;
                    LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetAutoDeployDirectoryCommand(LiferayServerSettingsEditorSection.this.tomcatServer, selectedDirectory));
                    LiferayServerSettingsEditorSection.this.autoDeployDir.setText(selectedDirectory);
                    LiferayServerSettingsEditorSection.this.updating = false;
                    LiferayServerSettingsEditorSection.this.validate();
                }
            }
        });
        this.autoDeployDirBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = this.createLabel(toolkit, composite, Msgs.autoDeployIntervalLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.autoDeployInterval = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        this.autoDeployInterval.setLayoutData((Object)data);
        this.autoDeployInterval.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LiferayServerSettingsEditorSection.this.updating) {
                    return;
                }
                LiferayServerSettingsEditorSection.this.updating = true;
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetAutoDeployIntervalCommand(LiferayServerSettingsEditorSection.this.tomcatServer, LiferayServerSettingsEditorSection.this.autoDeployInterval.getText()));
                LiferayServerSettingsEditorSection.this.updating = false;
                LiferayServerSettingsEditorSection.this.validate();
            }
        });
        this.createLabel(toolkit, composite, Msgs.millisecondsLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.setDefault = toolkit.createHyperlink(composite, Msgs.restoreDefaultsLink, 64);
        this.setDefault.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LiferayServerSettingsEditorSection.this.updating = true;
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetMemoryArgsCommand(LiferayServerSettingsEditorSection.this.tomcatServer, ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS));
                LiferayServerSettingsEditorSection.this.memoryArgs.setText(ILiferayTomcatConstants.DEFAULT_MEMORY_ARGS);
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetUserTimezoneCommand(LiferayServerSettingsEditorSection.this.tomcatServer, ILiferayTomcatConstants.DEFAULT_USER_TIMEZONE));
                LiferayServerSettingsEditorSection.this.userTimezone.setText(ILiferayTomcatConstants.DEFAULT_USER_TIMEZONE);
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(LiferayServerSettingsEditorSection.this.tomcatServer, ""));
                LiferayServerSettingsEditorSection.this.externalProperties.setText("");
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetAutoDeployDirectoryCommand(LiferayServerSettingsEditorSection.this.tomcatServer, "../deploy"));
                LiferayServerSettingsEditorSection.this.autoDeployDir.setText("../deploy");
                LiferayServerSettingsEditorSection.this.execute((IUndoableOperation)new SetAutoDeployIntervalCommand(LiferayServerSettingsEditorSection.this.tomcatServer, ILiferayTomcatConstants.DEFAULT_AUTO_DEPLOY_INTERVAL));
                LiferayServerSettingsEditorSection.this.autoDeployInterval.setText(ILiferayTomcatConstants.DEFAULT_AUTO_DEPLOY_INTERVAL);
                LiferayServerSettingsEditorSection.this.updating = false;
                LiferayServerSettingsEditorSection.this.validate();
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.setDefault.setLayoutData((Object)data);
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.workspacePath = root.getLocation();
        this.defaultDeployPath = new Path("webapps");
        if (this.server != null) {
            this.tomcatServer = (LiferayTomcatServer)this.server.loadAdapter(LiferayTomcatServer.class, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.autoDeployInterval == null || this.tomcatServer == null) {
            return;
        }
        this.updating = true;
        IRuntime runtime = this.server.getRuntime();
        if (runtime != null && runtime.getRuntimeType().getId().indexOf("32") < 0) {
            this.section.setDescription(Msgs.configureLiferayPortalServerSettings);
        }
        if (runtime != null) {
            this.installDirPath = runtime.getLocation();
        }
        this.allowRestrictedEditing = false;
        IPath basePath = this.tomcatServer.getRuntimeBaseDirectory();
        if (!this.readOnly && (basePath != null && !basePath.append("conf").toFile().exists() || this.server.getOriginal().getServerPublishState() == 1 && this.server.getOriginal().getModules().length == 0)) {
            this.allowRestrictedEditing = true;
        }
        this.updateServerDirButtons();
        this.updateDefaultDeployLink();
        this.memoryArgs.setText(this.tomcatServer.getMemoryArgs());
        this.userTimezone.setText(this.tomcatServer.getUserTimezone());
        this.externalProperties.setText(this.tomcatServer.getExternalProperties());
        this.autoDeployDir.setText(this.tomcatServer.getAutoDeployDirectory());
        this.autoDeployInterval.setText(this.tomcatServer.getAutoDeployInterval());
        this.updating = false;
        this.validate();
    }

    protected void updateServerDirButtons() {
        this.tomcatServer.getInstanceDirectory();
    }

    protected void updateServerDirFields() {
    }

    protected void updateDefaultDeployLink() {
    }

    public IStatus[] getSaveStatus() {
        if (this.tomcatServer != null) {
            File externalPropertiesFile;
            IPath path;
            String dir = this.tomcatServer.getInstanceDirectory();
            if (dir != null) {
                path = new Path(dir);
                if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                    return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.errorServerDirIsRoot)};
                }
                if (this.workspacePath.isPrefixOf(path) || !path.isAbsolute() && METADATADIR.equals(path.segment(0))) {
                    int cnt = path.matchingFirstSegments(this.workspacePath);
                    if (METADATADIR.equals(path.segment(cnt))) {
                        return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", NLS.bind((String)Msgs.errorServerDirUnderRoot, (Object)METADATADIR))};
                    }
                } else if (path.equals((Object)this.installDirPath)) {
                    return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", NLS.bind((String)Msgs.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Msgs.serverEditorServerDirInstall, (Object)"").trim()))};
                }
            } else {
                path = this.tomcatServer.getRuntimeBaseDirectory();
                if (!path.equals((Object)this.installDirPath)) {
                    return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.changingRuntimeBaseDirectoriesNotSupported)};
                }
            }
            if ((dir = this.tomcatServer.getDeployDirectory()) == null || dir.length() == 0) {
                return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.errorDeployDirNotSpecified)};
            }
            String externalPropetiesValue = this.tomcatServer.getExternalProperties();
            if (!(CoreUtil.isNullOrEmpty((String)externalPropetiesValue) || (externalPropertiesFile = new File(externalPropetiesValue)).exists() && ServerUtil.isValidPropertiesFile((File)externalPropertiesFile))) {
                return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.invalidExternalProperitesFile)};
            }
            String autoDeployInterval = this.tomcatServer.getAutoDeployInterval();
            if (CoreUtil.isNullOrEmpty((String)autoDeployInterval)) {
                return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.specifyAutoDeployInterval)};
            }
            try {
                Integer.parseInt(autoDeployInterval);
            }
            catch (NumberFormatException numberFormatException) {
                return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.autoDeployIntervalNotInteger)};
            }
        }
        return super.getSaveStatus();
    }

    protected void validate() {
        if (this.tomcatServer != null) {
            File externalPropertiesFile;
            IPath path;
            String dir = this.tomcatServer.getInstanceDirectory();
            if (dir != null) {
                path = new Path(dir);
                if (dir.length() == 0 || this.workspacePath.equals((Object)path)) {
                    this.setErrorMessage(Msgs.errorServerDirIsRoot);
                    return;
                }
                if (this.workspacePath.isPrefixOf(path) || !path.isAbsolute() && METADATADIR.equals(path.segment(0))) {
                    int cnt = path.matchingFirstSegments(this.workspacePath);
                    if (METADATADIR.equals(path.segment(cnt))) {
                        this.setErrorMessage(NLS.bind((String)Msgs.errorServerDirUnderRoot, (Object)METADATADIR));
                        return;
                    }
                } else if (path.equals((Object)this.installDirPath)) {
                    this.setErrorMessage(NLS.bind((String)Msgs.errorServerDirCustomNotInstall, (Object)NLS.bind((String)Msgs.serverEditorServerDirInstall, (Object)"").trim()));
                    return;
                }
            } else {
                path = this.tomcatServer.getRuntimeBaseDirectory();
                if (path != null && !path.equals((Object)this.installDirPath)) {
                    this.setErrorMessage(NLS.bind((String)Msgs.errorServerDirCustomNotMetadata, (Object)NLS.bind((String)Msgs.serverEditorServerDirMetadata, (Object)"").trim()));
                }
            }
            if ((dir = this.tomcatServer.getDeployDirectory()) == null || dir.length() == 0) {
                this.setErrorMessage(Msgs.errorDeployDirNotSpecified);
                return;
            }
            String externalPropetiesValue = this.tomcatServer.getExternalProperties();
            if (!(CoreUtil.isNullOrEmpty((String)externalPropetiesValue) || (externalPropertiesFile = new File(externalPropetiesValue)).exists() && ServerUtil.isValidPropertiesFile((File)externalPropertiesFile))) {
                this.setErrorMessage(Msgs.invalidExternalPropertiesFile);
                return;
            }
            String autoDeployInterval = this.tomcatServer.getAutoDeployInterval();
            if (CoreUtil.isNullOrEmpty((String)autoDeployInterval)) {
                this.setErrorMessage(Msgs.specifyAutoDeployInterval);
                return;
            }
            try {
                Integer.parseInt(autoDeployInterval);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Msgs.autoDeployIntervalNotInteger);
                return;
            }
        }
        this.setErrorMessage(null);
    }

    private static class Msgs
    extends NLS {
        public static String autoDeployIntervalLabel;
        public static String autoDeployIntervalNotInteger;
        public static String autoDeployPathLabel;
        public static String changingRuntimeBaseDirectoriesNotSupported;
        public static String configureLiferayPortalServerSettings;
        public static String editorBrowse;
        public static String errorDeployDirNotSpecified;
        public static String errorServerDirCustomNotInstall;
        public static String errorServerDirCustomNotMetadata;
        public static String errorServerDirIsRoot;
        public static String errorServerDirUnderRoot;
        public static String externalPropertiesLabel;
        public static String invalidExternalProperitesFile;
        public static String invalidExternalPropertiesFile;
        public static String liferaySettings;
        public static String memoryArgsLabel;
        public static String millisecondsLabel;
        public static String restoreDefaultsLink;
        public static String serverEditorBrowseDeployMessage;
        public static String serverEditorServerDirInstall;
        public static String serverEditorServerDirMetadata;
        public static String specifyAutoDeployInterval;
        public static String userTimezoneLabel;

        static {
            Msgs.initializeMessages((String)LiferayServerSettingsEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

