/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.sapphire.ui.def.MarginPresentation;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutOrientation;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.layout.LayoutUtil;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireSequenceLayoutConstraint;

public class SapphireSequenceLayout
extends AbstractHintLayout {
    private Map constraints = new HashMap();
    private Transposer transposer = new Transposer();
    private boolean horizontal;
    private int spacing;
    private Insets marginInsets;

    public SapphireSequenceLayout(SequenceLayoutDef def) {
        this.setHorizontal(def.getOrientation().content() == SequenceLayoutOrientation.HORIZONTAL);
        this.setSpacing((Integer)def.getSpacing().content());
        this.marginInsets = LayoutUtil.calculateMargin((MarginPresentation)def);
    }

    public void setHorizontal(boolean flag) {
        if (this.horizontal == flag) {
            return;
        }
        this.invalidate();
        this.horizontal = flag;
        this.updateTransposerEnabledState();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    private Dimension calculateChildrenSize(List children, int wHint, int hHint, boolean preferred) {
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(preferred ? this.getChildPreferredSize(child, wHint, hHint) : this.getChildMinimumSize(child, wHint, hHint));
            Insets inset = new Insets();
            SapphireSequenceLayoutConstraint constraint = (SapphireSequenceLayoutConstraint)this.getConstraint(child);
            if (constraint != null) {
                inset = this.transposer.t(constraint.getMarginInset());
            }
            height += childSize.height + inset.top + inset.bottom;
            width = Math.max(width, childSize.width + inset.left + inset.right);
            ++i;
        }
        return new Dimension(width, height);
    }

    private Dimension calculateChildrenMaximumSize(List children) {
        int height = 0;
        int width = Integer.MAX_VALUE;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(this.getChildCellMaximumSize(child));
            Insets inset = new Insets();
            SapphireSequenceLayoutConstraint constraint = (SapphireSequenceLayoutConstraint)this.getConstraint(child);
            if (constraint != null) {
                inset = this.transposer.t(constraint.getMarginInset());
            }
            width = Math.min(width, childSize.width + (childSize.width < Integer.MAX_VALUE ? inset.left + inset.right : 0));
            if (childSize.height < Integer.MAX_VALUE) {
                if (height < Integer.MAX_VALUE) {
                    height += childSize.height + inset.top + inset.bottom;
                }
            } else {
                height = Integer.MAX_VALUE;
            }
            ++i;
        }
        return new Dimension(width, height);
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List children = container.getChildren();
        Dimension minSize = this.calculateChildrenSize(children, wHint, hHint, false);
        if (wHint >= 0 && minSize.width > wHint) {
            minSize = this.calculateChildrenSize(children, minSize.width, hHint, false);
        } else if (hHint >= 0 && minSize.width > hHint) {
            minSize = this.calculateChildrenSize(children, wHint, minSize.width, false);
        }
        minSize.height += Math.max(0, children.size() - 1) * this.spacing;
        Insets inset = this.transposer.t(this.marginInsets);
        minSize.width += inset.left + inset.right;
        minSize.height += inset.top + inset.bottom;
        return this.transposer.t(minSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List children = container.getChildren();
        Dimension prefSize = this.calculateChildrenSize(children, wHint, hHint, true);
        if (wHint >= 0 && prefSize.width > wHint) {
            prefSize = this.calculateChildrenSize(children, prefSize.width, hHint, true);
        } else if (hHint >= 0 && prefSize.width > hHint) {
            prefSize = this.calculateChildrenSize(children, wHint, prefSize.width, true);
        }
        Dimension maxSize = this.calculateChildrenMaximumSize(children);
        Dimension minSize = this.calculateChildrenSize(children, wHint, hHint, false);
        prefSize.width = Math.min(maxSize.width, prefSize.width);
        prefSize.width = Math.max(minSize.width, prefSize.width);
        prefSize.height += Math.max(0, children.size() - 1) * this.spacing;
        Insets inset = this.transposer.t(this.marginInsets);
        prefSize.width += inset.left + inset.right;
        prefSize.height += inset.top + inset.bottom;
        return this.transposer.t(prefSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    public Dimension calculateMaximumSize(IFigure container) {
        List children = container.getChildren();
        Dimension maxSize = this.calculateChildrenMaximumSize(children);
        Insets marginInsets = this.transposer.t(this.marginInsets);
        if (maxSize.width < Integer.MAX_VALUE) {
            maxSize.width += marginInsets.left + marginInsets.right;
        }
        if (maxSize.height < Integer.MAX_VALUE) {
            maxSize.height += Math.max(0, children.size() - 1) * this.spacing;
            maxSize.height += marginInsets.top + marginInsets.bottom;
        }
        maxSize = this.transposer.t(maxSize);
        Insets containerInsets = container.getInsets();
        Dimension borderSize = this.getBorderPreferredSize(container);
        if (maxSize.width < Integer.MAX_VALUE) {
            maxSize.width += containerInsets.getWidth();
            maxSize.width = Math.max(borderSize.width, maxSize.width);
        }
        if (maxSize.height < Integer.MAX_VALUE) {
            maxSize.height += containerInsets.getHeight();
            maxSize.height = Math.max(borderSize.height, maxSize.height);
        }
        return maxSize;
    }

    protected Dimension getChildMinimumSize(IFigure child, int wHint, int hHint) {
        Dimension minSize = child.getMinimumSize(wHint, hHint).getCopy();
        SapphireSequenceLayoutConstraint constraint = (SapphireSequenceLayoutConstraint)this.getConstraint(child);
        if (constraint.minWidth > minSize.width) {
            minSize.width = constraint.minWidth;
        }
        if (constraint.minHeight > minSize.height) {
            minSize.height = constraint.minHeight;
        }
        return minSize;
    }

    protected Dimension getChildPreferredSize(IFigure child, int wHint, int hHint) {
        Dimension dimension = child.getPreferredSize(wHint, hHint).getCopy();
        Dimension minSize = child.getMinimumSize(wHint, hHint);
        SapphireSequenceLayoutConstraint constraint = (SapphireSequenceLayoutConstraint)this.getConstraint(child);
        if (constraint.widthHint > minSize.width) {
            dimension.width = constraint.widthHint;
        }
        if (constraint.heightHint > minSize.height) {
            dimension.height = constraint.heightHint;
        }
        if (constraint.minWidth > -1 && dimension.width < constraint.minWidth) {
            dimension.width = constraint.minWidth;
        }
        if (constraint.minHeight > -1 && dimension.height < constraint.minHeight) {
            dimension.height = constraint.minHeight;
        }
        if (constraint.maxWidth > -1 && dimension.width > constraint.maxWidth) {
            dimension.width = constraint.maxWidth;
        }
        if (constraint.maxHeight > -1 && dimension.height > constraint.maxHeight) {
            dimension.height = constraint.maxHeight;
        }
        return dimension;
    }

    protected Dimension getChildCellMaximumSize(IFigure child) {
        Dimension dimension = child.getMaximumSize().getCopy();
        SapphireSequenceLayoutConstraint constraint = (SapphireSequenceLayoutConstraint)this.getConstraint(child);
        if (constraint.expandHorizontally) {
            dimension.width = Integer.MAX_VALUE;
        }
        if (constraint.expandVertically) {
            dimension.height = Integer.MAX_VALUE;
        }
        if (constraint.maxWidth > -1 && constraint.maxWidth < Integer.MAX_VALUE) {
            dimension.width = Math.min(constraint.maxWidth, dimension.width);
        }
        if (constraint.maxHeight > -1 && constraint.maxHeight < Integer.MAX_VALUE) {
            dimension.height = Math.min(constraint.maxHeight, dimension.height);
        }
        return dimension;
    }

    protected int getDefaultOrientation() {
        return 128;
    }

    public int getSpacing() {
        return this.spacing;
    }

    protected boolean isSensitiveHorizontally(IFigure parent) {
        return !this.isHorizontal();
    }

    protected boolean isSensitiveVertically(IFigure parent) {
        return this.isHorizontal();
    }

    public void layout(IFigure parent) {
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        Insets margins = this.transposer.t(this.marginInsets);
        clientArea.x += margins.left;
        clientArea.width -= margins.left + margins.right;
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        Dimension[] maxCellSizes = new Dimension[numChildren];
        Dimension[] maxChildShapeSizes = new Dimension[numChildren];
        int[] extraHeights = new int[numChildren];
        SapphireSequenceLayoutConstraint[] constraints = new SapphireSequenceLayoutConstraint[numChildren];
        Insets[] marginInsets = new Insets[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height - (margins.top + margins.bottom);
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width - (margins.left + margins.right);
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        int prefMinSumHeight = 0;
        int totalMargin = 0;
        int expandCount = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            SapphireSequenceLayoutConstraint constraint = (SapphireSequenceLayoutConstraint)this.getConstraint(child);
            if (constraint == null) {
                constraint = new SapphireSequenceLayoutConstraint();
                this.setConstraint(child, constraint);
            }
            constraints[i] = constraint;
            prefSizes[i] = this.transposer.t(this.getChildPreferredSize(child, wHint, hHint));
            minSizes[i] = this.transposer.t(this.getChildMinimumSize(child, wHint, hHint));
            maxCellSizes[i] = this.transposer.t(this.getChildCellMaximumSize(child));
            maxChildShapeSizes[i] = this.transposer.t(child.getMaximumSize());
            marginInsets[i] = this.transposer.t(constraint.getMarginInset());
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            totalMargin += marginInsets[i].top + marginInsets[i].bottom;
            if (this.getMajorExpand(constraint) || maxChildShapeSizes[i].height > prefSizes[i].height) {
                ++expandCount;
            }
            ++i;
        }
        totalHeight += (numChildren - 1) * this.spacing;
        totalMinHeight += (numChildren - 1) * this.spacing;
        prefMinSumHeight = (totalHeight += totalMargin + margins.top + margins.bottom) - (totalMinHeight += totalMargin + margins.top + margins.bottom);
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        int extraHeight = -amntShrinkHeight;
        if (amntShrinkHeight < 0) {
            amntShrinkHeight = 0;
        }
        if (extraHeight <= 0) {
            extraHeight = 0;
        } else if (expandCount > 0) {
            int averageExtraHeight = extraHeight / expandCount;
            int limitedExpansionCount = 0;
            int limitedExpansionHeightTotal = 0;
            if (expandCount > 1) {
                int i2 = 0;
                while (i2 < numChildren) {
                    int prefHeight = prefSizes[i2].height;
                    int maxCellHeight = maxCellSizes[i2].height;
                    child = (IFigure)children.get(i2);
                    SapphireSequenceLayoutConstraint constraint = constraints[i2];
                    if ((this.getMajorExpand(constraint) || maxCellHeight > prefHeight) && maxCellHeight - prefHeight < averageExtraHeight) {
                        ++limitedExpansionCount;
                        limitedExpansionHeightTotal += maxCellHeight - prefHeight;
                    }
                    ++i2;
                }
            }
            int unlimitedExpansionAverage = limitedExpansionCount < expandCount ? (extraHeight - limitedExpansionHeightTotal) / (expandCount - limitedExpansionCount) : 0;
            int i3 = 0;
            while (i3 < numChildren) {
                int prefHeight = prefSizes[i3].height;
                int maxCellHeight = maxCellSizes[i3].height;
                child = (IFigure)children.get(i3);
                SapphireSequenceLayoutConstraint constraint = constraints[i3];
                extraHeights[i3] = this.getMajorExpand(constraint) || maxCellHeight > prefHeight ? (expandCount > 1 && maxCellHeight - prefHeight < averageExtraHeight ? maxCellHeight - prefHeight : unlimitedExpansionAverage) : 0;
                ++i3;
            }
        }
        y += margins.top;
        int i4 = 0;
        while (i4 < numChildren) {
            Rectangle newBounds;
            int amntShrinkCurrentHeight = 0;
            child = (IFigure)children.get(i4);
            int prefHeight = prefSizes[i4].height;
            int minHeight = minSizes[i4].height;
            int prefWidth = prefSizes[i4].width;
            int minWidth = minSizes[i4].width;
            Insets marginInset = marginInsets[i4];
            SapphireSequenceLayoutConstraint constraint = constraints[i4];
            if (prefMinSumHeight != 0) {
                amntShrinkCurrentHeight = (prefHeight - minHeight) * amntShrinkHeight / prefMinSumHeight;
            }
            int height = prefHeight;
            if (amntShrinkCurrentHeight != 0) {
                newBounds = new Rectangle(x, y + marginInset.top, prefWidth, height -= amntShrinkCurrentHeight);
                amntShrinkHeight -= amntShrinkCurrentHeight;
                prefMinSumHeight -= prefHeight - minHeight;
            } else if (this.getMajorExpand(constraint) || maxChildShapeSizes[i4].height > prefSizes[i4].height) {
                height += extraHeights[i4];
                if (maxChildShapeSizes[i4].height > prefSizes[i4].height) {
                    newBounds = new Rectangle(x, y + marginInset.top, prefWidth, height);
                } else {
                    int offset = 0;
                    switch (this.getMajorAlignment(constraint)) {
                        case 0x1000000: {
                            offset = extraHeights[i4] >> 1;
                            break;
                        }
                        case 1024: 
                        case 131072: {
                            offset = extraHeights[i4];
                            break;
                        }
                    }
                    newBounds = new Rectangle(x, y + marginInset.top + offset, prefWidth, prefHeight);
                }
            } else {
                newBounds = new Rectangle(x, y + marginInset.top, prefWidth, height);
            }
            int availableBoundHeight = height;
            int width = Math.min(prefWidth, maxCellSizes[i4].width);
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            Rectangle availableBounds = new Rectangle(x + marginInset.left, y + marginInset.top, clientArea.width - marginInset.left - marginInset.right, availableBoundHeight);
            if (maxChildShapeSizes[i4].width > prefSizes[i4].width) {
                newBounds.x += marginInset.left;
                newBounds.width = clientArea.width - marginInset.left - marginInset.right;
            } else {
                int adjust = clientArea.width - width - marginInset.left - marginInset.right;
                if (adjust <= 0) {
                    adjust = 0;
                } else {
                    switch (this.getMinorAlignment(constraint)) {
                        case 128: 
                        case 16384: {
                            adjust = 0;
                            break;
                        }
                        case 0x1000000: {
                            adjust = adjust + 1 >> 1;
                            break;
                        }
                    }
                }
                newBounds.x += adjust + marginInset.left;
            }
            child.setBounds(this.transposer.t(newBounds));
            if (child instanceof TextFigure) {
                ((TextFigure)child).setAvailableArea(this.transposer.t(availableBounds));
                ((TextFigure)child).setHorizontalAlignment(constraint.horizontalAlignment);
            }
            y += availableBoundHeight + this.spacing + marginInset.top + marginInset.bottom;
            ++i4;
        }
    }

    private int getMajorAlignment(SapphireSequenceLayoutConstraint constraint) {
        return this.isHorizontal() ? constraint.horizontalAlignment : constraint.verticalAlignment;
    }

    private int getMinorAlignment(SapphireSequenceLayoutConstraint constraint) {
        return this.isHorizontal() ? constraint.verticalAlignment : constraint.horizontalAlignment;
    }

    private boolean getMajorExpand(SapphireSequenceLayoutConstraint constraint) {
        return this.isHorizontal() ? constraint.expandHorizontally : constraint.expandVertically;
    }

    private boolean getMinorExpand(SapphireSequenceLayoutConstraint constraint) {
        return this.isHorizontal() ? constraint.expandVertically : constraint.expandHorizontally;
    }

    public void setSpacing(int space) {
        this.spacing = space;
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    private void updateTransposerEnabledState() {
        this.transposer.setEnabled(this.isHorizontal() && this.getDefaultOrientation() == 128 || !this.isHorizontal() && this.getDefaultOrientation() == 64);
    }
}

