/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import java.util.Collection;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JpaStructureNode
extends JpaContextModel {
    public static final String CHILDREN_COLLECTION = "children";

    public TextRange getFullTextRange();

    public boolean containsOffset(int var1);

    public JpaStructureNode getStructureNode(int var1);

    public TextRange getSelectionTextRange();

    public ContextType getContextType();

    public Class<? extends JpaStructureNode> getType();

    public Iterable<? extends JpaStructureNode> getChildren();

    public int getChildrenSize();

    public void addRootStructureNodesTo(JpaFile var1, Collection<JpaStructureNode> var2);

    public static final class ContextType {
        private final JpaStructureNode node;

        public ContextType(JpaStructureNode node) {
            if (node == null) {
                throw new NullPointerException();
            }
            this.node = node;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ContextType other = (ContextType)obj;
            return this.node.getJpaPlatform().equals(other.node.getJpaPlatform()) && this.node.getResourceType().equals(other.node.getResourceType()) && this.node.getType().equals(other.node.getType());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.node.getJpaPlatform().hashCode();
            hash = hash * 31 + this.node.getResourceType().hashCode();
            hash = hash * 31 + this.node.getType().hashCode();
            return hash;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.node);
        }
    }
}

