/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumArrayDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.RelationshipMappingAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.CascadeType;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceRelationshipMappingAnnotation
extends SourceAnnotation
implements RelationshipMappingAnnotation2_0 {
    final DeclarationAnnotationElementAdapter<String> targetEntityDeclarationAdapter;
    final AnnotationElementAdapter<String> targetEntityAdapter;
    String targetEntity;
    TextRange targetEntityTextRange;
    private String fullyQualifiedTargetEntityClassName;
    private boolean fqTargetEntityClassNameStale = true;
    final DeclarationAnnotationElementAdapter<String> fetchDeclarationAdapter;
    final AnnotationElementAdapter<String> fetchAdapter;
    FetchType fetch;
    TextRange fetchTextRange;
    final DeclarationAnnotationElementAdapter<String[]> cascadeDeclarationAdapter;
    final AnnotationElementAdapter<String[]> cascadeAdapter;
    CascadeType[] cascadeTypes = EMPTY_CASCADE_TYPE_ARRAY;
    TextRange cascadeTextRange;
    private static final CascadeType[] EMPTY_CASCADE_TYPE_ARRAY = new CascadeType[0];

    SourceRelationshipMappingAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super((JavaResourceModel)parent, element, daa);
        this.targetEntityDeclarationAdapter = this.getTargetEntityAdapter();
        this.targetEntityAdapter = this.buildAnnotationElementAdapter(this.targetEntityDeclarationAdapter);
        this.fetchDeclarationAdapter = this.getFetchAdapter();
        this.fetchAdapter = this.buildAnnotationElementAdapter(this.fetchDeclarationAdapter);
        this.cascadeDeclarationAdapter = this.getCascadeAdapter();
        this.cascadeAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.cascadeDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Boolean> buildBooleanAnnotationElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.targetEntity = this.buildTargetEntity(astAnnotation);
        this.targetEntityTextRange = this.buildTargetEntityTextRange(astAnnotation);
        this.fetch = this.buildFetch(astAnnotation);
        this.fetchTextRange = this.buildFetchTextRange(astAnnotation);
        this.cascadeTypes = this.buildCascadeTypes(astAnnotation);
        this.cascadeTextRange = this.buildCascadeTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncFetch(this.buildFetch(astAnnotation));
        this.targetEntityTextRange = this.buildTargetEntityTextRange(astAnnotation);
        this.syncTargetEntity(this.buildTargetEntity(astAnnotation));
        this.fetchTextRange = this.buildFetchTextRange(astAnnotation);
        this.syncCascadeTypes(this.buildCascadeTypes(astAnnotation));
        this.cascadeTextRange = this.buildCascadeTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.targetEntity == null && this.fetch == null && this.cascadeTypes.length == 0;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.targetEntity);
    }

    @Override
    public String getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public void setTargetEntity(String targetEntity) {
        if (this.attributeValueHasChanged(this.targetEntity, targetEntity)) {
            this.targetEntity = targetEntity;
            this.fqTargetEntityClassNameStale = true;
            this.targetEntityAdapter.setValue((Object)targetEntity);
        }
    }

    private void syncTargetEntity(String astTargetEntity) {
        if (this.attributeValueHasChanged(this.targetEntity, astTargetEntity)) {
            this.syncTargetEntity_(astTargetEntity);
        }
    }

    private void syncTargetEntity_(String astTargetEntity) {
        String old = this.targetEntity;
        this.targetEntity = astTargetEntity;
        this.fqTargetEntityClassNameStale = true;
        this.firePropertyChanged("targetEntity", old, astTargetEntity);
    }

    private String buildTargetEntity(Annotation astAnnotation) {
        return (String)this.targetEntityAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getTargetEntityTextRange() {
        return this.targetEntityTextRange;
    }

    private TextRange buildTargetEntityTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.targetEntityDeclarationAdapter, astAnnotation);
    }

    abstract DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter();

    @Override
    public String getFullyQualifiedTargetEntityClassName() {
        if (this.fqTargetEntityClassNameStale) {
            this.fullyQualifiedTargetEntityClassName = this.buildFullyQualifiedTargetEntityClassName();
            this.fqTargetEntityClassNameStale = false;
        }
        return this.fullyQualifiedTargetEntityClassName;
    }

    private String buildFullyQualifiedTargetEntityClassName() {
        return this.targetEntity == null ? null : this.buildFullyQualifiedTargetEntityClassName_();
    }

    private String buildFullyQualifiedTargetEntityClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.targetEntityAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasChanged((Object)this.fetch, (Object)fetch)) {
            this.fetch = fetch;
            this.fetchAdapter.setValue((Object)FetchType.toJavaAnnotationValue(fetch));
        }
    }

    private void syncFetch(FetchType astFetch) {
        FetchType old = this.fetch;
        this.fetch = astFetch;
        this.firePropertyChanged("fetch", (Object)old, (Object)astFetch);
    }

    private FetchType buildFetch(Annotation astAnnotation) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astAnnotation));
    }

    @Override
    public TextRange getFetchTextRange() {
        return this.fetchTextRange;
    }

    private TextRange buildFetchTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.fetchDeclarationAdapter, astAnnotation);
    }

    abstract DeclarationAnnotationElementAdapter<String> getFetchAdapter();

    private void setCascadeType(CascadeType cascadeType, boolean set) {
        this.setCascadeTypes(set ? (CascadeType[])ArrayTools.add((Object[])this.cascadeTypes, (Object)((Object)cascadeType)) : (CascadeType[])ArrayTools.remove((Object[])this.cascadeTypes, (Object)((Object)cascadeType)));
    }

    private void setCascadeTypes(CascadeType[] cascadeTypes) {
        this.cascadeTypes = cascadeTypes;
        this.cascadeAdapter.setValue((Object)CascadeType.toJavaAnnotationValues(cascadeTypes));
    }

    private void syncCascadeTypes(CascadeType[] astCascadeTypes) {
        CascadeType[] old = this.cascadeTypes;
        this.cascadeTypes = astCascadeTypes;
        this.syncCascadeAll(old);
        this.syncCascadeMerge(old);
        this.syncCascadePersist(old);
        this.syncCascadeRefresh(old);
        this.syncCascadeRemove(old);
        this.syncCascadeDetach(old);
    }

    private CascadeType[] buildCascadeTypes(Annotation astAnnotation) {
        return CascadeType.fromJavaAnnotationValues((Object[])this.cascadeAdapter.getValue(astAnnotation));
    }

    private boolean cascadeTypeIsTrue(CascadeType cascadeType) {
        return ArrayTools.contains((Object[])this.cascadeTypes, (Object)((Object)cascadeType));
    }

    @Override
    public TextRange getCascadeTextRange() {
        return this.cascadeTextRange;
    }

    private TextRange buildCascadeTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.cascadeDeclarationAdapter, astAnnotation);
    }

    abstract DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter();

    @Override
    public boolean isCascadeAll() {
        return this.cascadeTypeIsTrue(CascadeType.ALL);
    }

    @Override
    public void setCascadeAll(boolean cascadeAll) {
        if (this.isCascadeAll() != cascadeAll) {
            this.setCascadeType(CascadeType.ALL, cascadeAll);
        }
    }

    private void syncCascadeAll(CascadeType[] oldCascadeTypes) {
        boolean old = ArrayTools.contains((Object[])oldCascadeTypes, (Object)((Object)CascadeType.ALL));
        this.firePropertyChanged("cascadeAll", old, this.isCascadeAll());
    }

    @Override
    public boolean isCascadePersist() {
        return this.cascadeTypeIsTrue(CascadeType.PERSIST);
    }

    @Override
    public void setCascadePersist(boolean cascadePersist) {
        if (this.isCascadePersist() != cascadePersist) {
            this.setCascadeType(CascadeType.PERSIST, cascadePersist);
        }
    }

    private void syncCascadePersist(CascadeType[] oldCascadeTypes) {
        boolean old = ArrayTools.contains((Object[])oldCascadeTypes, (Object)((Object)CascadeType.PERSIST));
        this.firePropertyChanged("cascadePersist", old, this.isCascadePersist());
    }

    @Override
    public boolean isCascadeMerge() {
        return this.cascadeTypeIsTrue(CascadeType.MERGE);
    }

    @Override
    public void setCascadeMerge(boolean cascadeMerge) {
        if (this.isCascadeMerge() != cascadeMerge) {
            this.setCascadeType(CascadeType.MERGE, cascadeMerge);
        }
    }

    private void syncCascadeMerge(CascadeType[] oldCascadeTypes) {
        boolean old = ArrayTools.contains((Object[])oldCascadeTypes, (Object)((Object)CascadeType.MERGE));
        this.firePropertyChanged("cascadeMerge", old, this.isCascadeMerge());
    }

    @Override
    public boolean isCascadeRemove() {
        return this.cascadeTypeIsTrue(CascadeType.REMOVE);
    }

    @Override
    public void setCascadeRemove(boolean cascadeRemove) {
        if (this.isCascadeRemove() != cascadeRemove) {
            this.setCascadeType(CascadeType.REMOVE, cascadeRemove);
        }
    }

    private void syncCascadeRemove(CascadeType[] oldCascadeTypes) {
        boolean old = ArrayTools.contains((Object[])oldCascadeTypes, (Object)((Object)CascadeType.REMOVE));
        this.firePropertyChanged("cascadeRemove", old, this.isCascadeRemove());
    }

    @Override
    public boolean isCascadeRefresh() {
        return this.cascadeTypeIsTrue(CascadeType.REFRESH);
    }

    @Override
    public void setCascadeRefresh(boolean cascadeRefresh) {
        if (this.isCascadeRefresh() != cascadeRefresh) {
            this.setCascadeType(CascadeType.REFRESH, cascadeRefresh);
        }
    }

    private void syncCascadeRefresh(CascadeType[] oldCascadeTypes) {
        boolean old = ArrayTools.contains((Object[])oldCascadeTypes, (Object)((Object)CascadeType.REFRESH));
        this.firePropertyChanged("cascadeRefresh", old, this.isCascadeRefresh());
    }

    @Override
    public boolean isCascadeDetach() {
        return this.cascadeTypeIsTrue(CascadeType.DETACH);
    }

    @Override
    public void setCascadeDetach(boolean cascadeDetach) {
        if (this.isCascadeDetach() != cascadeDetach) {
            this.setCascadeType(CascadeType.DETACH, cascadeDetach);
        }
    }

    private void syncCascadeDetach(CascadeType[] oldCascadeTypes) {
        boolean old = ArrayTools.contains((Object[])oldCascadeTypes, (Object)((Object)CascadeType.DETACH));
        this.firePropertyChanged("cascadeDetach", old, this.isCascadeDetach());
    }

    static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceRelationshipMappingAnnotation.buildAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    static DeclarationAnnotationElementAdapter<String> buildFetchAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumDeclarationAnnotationElementAdapter(annotationAdapter, elementName);
    }

    static DeclarationAnnotationElementAdapter<String[]> buildEnumArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumArrayDeclarationAnnotationElementAdapter(annotationAdapter, elementName);
    }
}

