/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class OSGiFrameworkPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fTableViewer;
    private String fDefaultFramework;

    public OSGiFrameworkPreferencePage() {
        this.setDefaultFramework();
    }

    private void setDefaultFramework() {
        PDEPreferencesManager preferenceManager = PDELaunchingPlugin.getDefault().getPreferenceManager();
        this.fDefaultFramework = preferenceManager.getString("Preference.default.osgi.framework");
    }

    protected Control createContents(Composite parent) {
        IConfigurationElement element;
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        Link text = new Link(comp, 64);
        final IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint("org.eclipse.pde.ui.osgiFrameworks");
        text.setText(point != null && SchemaRegistry.getSchemaURL((IPluginExtensionPoint)point) != null ? PDEUIMessages.OSGiFrameworkPreferencePage_installed : PDEUIMessages.OSGiFrameworkPreferencePage_installed_nolink);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ShowDescriptionAction(point, true).run();
            }
        });
        this.fTableViewer = new CheckboxTableViewer(new Table(comp, 67620));
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FrameworkLabelProvider());
        this.fTableViewer.setInput((Object)PDELaunchingPlugin.getDefault().getOSGiFrameworkManager().getSortedFrameworks());
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IConfigurationElement element = (IConfigurationElement)event.getElement();
                OSGiFrameworkPreferencePage.this.fTableViewer.setCheckedElements(new Object[]{element});
                OSGiFrameworkPreferencePage.this.fDefaultFramework = element.getAttribute("id");
                OSGiFrameworkPreferencePage.this.fTableViewer.refresh();
            }
        });
        if (this.fDefaultFramework != null && (element = PDELaunchingPlugin.getDefault().getOSGiFrameworkManager().getFramework(this.fDefaultFramework)) != null) {
            this.fTableViewer.setCheckedElements(new Object[]{element});
        }
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.osgi_preference_page");
        return comp;
    }

    public boolean performOk() {
        IEclipsePreferences instancePrefs = new InstanceScope().getNode("org.eclipse.pde.launching");
        IEclipsePreferences defaultPrefs = new DefaultScope().getNode("org.eclipse.pde.launching");
        if (defaultPrefs.get("Preference.default.osgi.framework", "").equals(this.fDefaultFramework)) {
            instancePrefs.remove("Preference.default.osgi.framework");
        } else {
            instancePrefs.put("Preference.default.osgi.framework", this.fDefaultFramework);
        }
        try {
            instancePrefs.flush();
        }
        catch (BackingStoreException e) {
            PDEPlugin.log(e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.setDefaultFramework();
        this.fTableViewer.refresh();
    }

    public void init(IWorkbench workbench) {
    }

    class FrameworkLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font font = null;

        FrameworkLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_BUNDLE);
        }

        public String getText(Object element) {
            if (element instanceof IConfigurationElement) {
                String name = ((IConfigurationElement)element).getAttribute("name");
                String id = ((IConfigurationElement)element).getAttribute("id");
                return OSGiFrameworkPreferencePage.this.fDefaultFramework.equals(id) ? String.valueOf(name) + " " + PDEUIMessages.OSGiFrameworkPreferencePage_default : name;
            }
            return super.getText(element);
        }

        public Font getFont(Object element) {
            if (element instanceof IConfigurationElement) {
                String id = ((IConfigurationElement)element).getAttribute("id");
                if (OSGiFrameworkPreferencePage.this.fDefaultFramework.equals(id)) {
                    if (this.font == null) {
                        Font dialogFont = JFaceResources.getDialogFont();
                        FontData[] fontData = dialogFont.getFontData();
                        int i = 0;
                        while (i < fontData.length) {
                            FontData data = fontData[i];
                            data.setStyle(1);
                            ++i;
                        }
                        Display display = OSGiFrameworkPreferencePage.this.getControl().getShell().getDisplay();
                        this.font = new Font((Device)display, fontData);
                    }
                    return this.font;
                }
            }
            return null;
        }

        public void dispose() {
            if (this.font != null) {
                this.font.dispose();
            }
            super.dispose();
        }
    }
}

