/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.theme.core.ThemeCore;
import com.liferay.ide.theme.core.operation.ThemeDescriptorHelper;
import com.liferay.ide.theme.core.util.BuildHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ThemeCSSBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "com.liferay.ide.eclipse.theme.core.cssBuilder";
    private BuildHelper buildHelper = new BuildHelper();

    public static IStatus compileTheme(IProject project) throws CoreException {
        SDK sdk = SDKUtil.getSDK((IProject)project);
        if (sdk == null) {
            throw new CoreException(ThemeCore.createErrorStatus("No SDK for project configured. Could not build theme."));
        }
        Map appServerProperties = ServerUtil.configureAppServerProperties((IProject)project);
        IStatus status = sdk.compileThemePlugin(project, null, appServerProperties);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        ThemeCSSBuilder.ensureLookAndFeelFileExists(project);
        try {
            project.refreshLocal(2, null);
        }
        catch (Exception e) {
            ThemeCore.logError(e);
        }
        return status;
    }

    public static void ensureLookAndFeelFileExists(IProject project) throws CoreException {
        IVirtualFile file;
        IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)project);
        IVirtualFile lookAndFeelFile = null;
        if (webappRoot != null && (file = webappRoot.getFile((IPath)new Path("WEB-INF/liferay-look-and-feel.xml"))) != null && file.exists()) {
            lookAndFeelFile = file;
        }
        if (lookAndFeelFile == null) {
            String id = project.getName().replaceAll("-theme", "");
            IVirtualFile propertiesFile = webappRoot.getFile((IPath)new Path("WEB-INF/liferay-plugin-package.properties"));
            String name = id;
            if (propertiesFile != null && propertiesFile.exists()) {
                Properties props = new Properties();
                try {
                    IFile underlyingFile = propertiesFile.getUnderlyingFile();
                    props.load(underlyingFile.getContents());
                    String nameValue = props.getProperty("name");
                    if (!CoreUtil.isNullOrEmpty((String)nameValue)) {
                        name = nameValue;
                    }
                    ThemeDescriptorHelper themeDescriptorHelper = new ThemeDescriptorHelper(project);
                    ILiferayProject lProject = LiferayCore.create((Object)project);
                    themeDescriptorHelper.createDefaultFile(underlyingFile.getParent(), lProject.getPortalVersion(), id, name, ThemeCore.getThemeProperty("theme.type", project));
                }
                catch (IOException e) {
                    ThemeCore.logError("Unable to load plugin package properties.", e);
                }
            }
        }
    }

    protected void applyDiffsDeltaToDocroot(final IResourceDelta delta, final IContainer docroot, IProgressMonitor monitor) {
        int deltaKind = delta.getKind();
        switch (deltaKind) {
            default: 
        }
        final IPath path = CoreUtil.getResourceLocation((IResource)docroot);
        String themeParent = ThemeCore.getThemeProperty("theme.parent", this.getProject());
        ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
        IPath themesPath = liferayProject.getAppServerPortalDir().append("html/themes");
        final ArrayList<IPath> restorePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < IPluginProjectDataModelProperties.THEME_PARENTS.length) {
            if (IPluginProjectDataModelProperties.THEME_PARENTS[i].equals(themeParent)) {
                restorePaths.add(themesPath.append(IPluginProjectDataModelProperties.THEME_PARENTS[i]));
            } else if (restorePaths.size() > 0) {
                restorePaths.add(themesPath.append(IPluginProjectDataModelProperties.THEME_PARENTS[i]));
            }
            ++i;
        }
        new Job("publish theme delta"){

            protected IStatus run(IProgressMonitor monitor) {
                ThemeCSSBuilder.this.buildHelper.publishDelta(delta, path, restorePaths.toArray(new IPath[0]), monitor);
                try {
                    docroot.refreshLocal(2, monitor);
                }
                catch (Exception e) {
                    ThemeCore.logError(e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        if (kind == 6) {
            this.fullBuild(args, monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(args, monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(Map args, IProgressMonitor monitor) {
        try {
            if (this.shouldFullBuild(args)) {
                ThemeCSSBuilder.compileTheme(this.getProject(args));
            }
        }
        catch (Exception e) {
            ThemeCore.logError("Full build failed for Theme CSS Builder", e);
        }
    }

    protected IProject getProject(Map args) {
        return this.getProject();
    }

    protected void incrementalBuild(IResourceDelta delta, final IProgressMonitor monitor) {
        int deltaKind = delta.getKind();
        if (deltaKind == 2) {
            return;
        }
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    IPath fullResourcePath = resource.getFullPath();
                    String[] stringArray = fullResourcePath.segments();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath relPath;
                        String segment = stringArray[n2];
                        if ("_diffs".equals(segment)) {
                            IVirtualFolder diffs;
                            IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)ThemeCSSBuilder.this.getProject());
                            if (webappRoot != null && (diffs = webappRoot.getFolder((IPath)new Path("_diffs"))) != null && diffs.exists() && diffs.getUnderlyingFolder().getFullPath().isPrefixOf(fullResourcePath)) {
                                ThemeCSSBuilder.this.applyDiffsDeltaToDocroot(delta, diffs.getUnderlyingFolder().getParent(), monitor);
                                return false;
                            }
                        } else if ("build.xml".equals(segment) && (relPath = resource.getProjectRelativePath()) != null && relPath.segmentCount() == 1) {
                            try {
                                ThemeCSSBuilder.compileTheme(resource.getProject());
                            }
                            catch (CoreException e) {
                                ThemeCore.logError("Error compiling theme.", (Exception)((Object)e));
                            }
                        }
                        ++n2;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            ThemeCore.logError((Exception)((Object)e));
        }
    }

    protected boolean shouldFullBuild(Map args) throws CoreException {
        Object[] diffMembers;
        IVirtualFolder diffs;
        if (args != null && args.get("force") != null && args.get("force").equals("true")) {
            return true;
        }
        IVirtualFolder webappRoot = CoreUtil.getDocroot((IProject)this.getProject());
        return webappRoot != null && (diffs = webappRoot.getFolder((IPath)new Path("_diffs"))) != null && diffs.exists() && !CoreUtil.isNullOrEmpty((Object[])(diffMembers = diffs.getUnderlyingResources()));
    }
}

