/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core.facet;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.facet.PluginFacetInstall;
import com.liferay.ide.theme.core.ThemeCore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ThemePluginFacetInstall
extends PluginFacetInstall {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFolder libFolder;
        Object[] libFiles;
        IResource libRes;
        super.execute(project, fv, config, monitor);
        IDataModel model = (IDataModel)config;
        IDataModel masterModel = (IDataModel)model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (masterModel != null && masterModel.getBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION")) {
            String themeName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.THEME_NAME");
            IPath projectTempPath = (IPath)masterModel.getProperty("IPluginProjectDataModelProperties.PROJECT_TEMP_PATH");
            this.processNewFiles(projectTempPath.append(String.valueOf(themeName) + "-theme"));
            FileUtil.deleteDir((File)projectTempPath.toFile(), (boolean)true);
            CoreUtil.deleteResource((IResource)project.findMember("docroot/META-INF"));
        } else if (this.shouldSetupDefaultOutputLocation()) {
            this.setupDefaultOutputLocation();
        }
        if (this.shouldConfigureDeploymentAssembly()) {
            this.configureDeploymentAssembly("docroot/WEB-INF/src", "/WEB-INF/classes");
        }
        if ((libRes = CoreUtil.getDefaultDocrootFolder((IProject)project).findMember("WEB-INF/lib")) != null && libRes.exists() && CoreUtil.isNullOrEmpty((Object[])(libFiles = (libFolder = (IFolder)libRes).members(true)))) {
            libRes.delete(true, monitor);
        }
        if (this.shouldUpdateBuildXml()) {
            this.updateBuildXml(project);
        }
        if (this.shouldInstallThemeBuilder()) {
            this.installThemeBuilder(this.project);
        }
        try {
            this.project.refreshLocal(2, monitor);
        }
        catch (Exception e) {
            ThemeCore.logError(e);
        }
    }

    protected String getDefaultOutputLocation() {
        return "docroot/WEB-INF/classes";
    }

    public String getTemplateExtension(String tplFramework) {
        HashMap<String, String> tplMap = new HashMap<String, String>();
        tplMap.put("Velocity", "vm");
        tplMap.put("Freemarker", "ftl");
        tplMap.put("JSP", "jsp");
        return (String)tplMap.get(tplFramework);
    }

    protected void installThemeBuilder(IProject project) throws CoreException {
        ICommand command;
        ICommand[] commands;
        if (project == null) {
            return;
        }
        IProjectDescription desc = project.getDescription();
        ICommand[] iCommandArray = commands = desc.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            command = iCommandArray[n2];
            if ("com.liferay.ide.eclipse.theme.core.cssBuilder".equals(command.getBuilderName())) {
                return;
            }
            ++n2;
        }
        command = desc.newCommand();
        command.setBuilderName("com.liferay.ide.eclipse.theme.core.cssBuilder");
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 1, commands.length);
        nc[0] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
    }

    protected void removeUnneededClasspathEntries() {
        IFacetedProjectWorkingCopy facetedProject = this.getFacetedProject();
        IJavaProject javaProject = JavaCore.create((IProject)facetedProject.getProject());
        try {
            IClasspathEntry[] existingClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = existingClasspath;
            int n = existingClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!(entry.getEntryKind() == 3 || entry.getEntryKind() == 5 && ((path = entry.getPath().toPortableString()).contains("org.eclipse.jdt.launching.JRE_CONTAINER") || path.contains("org.eclipse.jst.j2ee.internal.web.container") || path.contains("org.eclipse.jst.j2ee.internal.module.container")))) {
                    newClasspath.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[0]), null);
            IResource sourceFolder = javaProject.getProject().findMember("docroot/WEB-INF/src");
            if (sourceFolder.exists()) {
                sourceFolder.delete(true, null);
            }
        }
        catch (Exception exception) {}
    }

    protected boolean shouldInstallThemeBuilder() {
        return this.model.getBooleanProperty("IPluginProjectDataModelProperties.INSTALL_THEME_CSS_BUILDER");
    }

    protected boolean shouldUpdateBuildXml() {
        return this.model.getBooleanProperty("IPluginProjectDataModelProperties.UPDATE_BUILD_XML");
    }

    public void updateBuildXml(IProject project) throws CoreException {
        String themeParent = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.THEME_PARENT");
        String tplFramework = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.THEME_TEMPLATE_FRAMEWORK");
        if (themeParent != null && !themeParent.equals(this.masterModel.getDefaultProperty("IPluginProjectDataModelProperties.THEME_PARENT")) || tplFramework != null && !tplFramework.equals(this.masterModel.getDefaultProperty("IPluginProjectDataModelProperties.THEME_TEMPLATE_FRAMEWORK"))) {
            IFile buildXml = project.getFile("build.xml");
            InputStream inputStream = buildXml.getContents();
            try {
                String strCon = CoreUtil.readStreamToString((InputStream)inputStream);
                inputStream.close();
                if (!themeParent.equals(this.masterModel.getDefaultProperty("IPluginProjectDataModelProperties.THEME_PARENT"))) {
                    strCon = strCon.replace("<property name=\"theme.parent\" value=\"_styled\" />", "<property name=\"theme.parent\" value=\"" + themeParent + "\" />");
                }
                if (!tplFramework.equals(this.masterModel.getDefaultProperty("IPluginProjectDataModelProperties.THEME_TEMPLATE_FRAMEWORK"))) {
                    String tplExtension = this.getTemplateExtension(tplFramework);
                    strCon = strCon.replace("</project>", "\t<property name=\"theme.type\" value=\"" + tplExtension + "\" />\n</project>");
                }
                buildXml.setContents((InputStream)new ByteArrayInputStream(strCon.getBytes()), 1, null);
            }
            catch (IOException e) {
                ThemeCore.logError(e);
            }
        }
    }
}

