/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal;

import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.VersionComparator;
import org.eclipse.jpt.jpa.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformFactory;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.internal.GenericJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatform;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatformFactory;
import org.eclipse.jpt.jpa.core.internal.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaFactory;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaPlatformProvider;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkJPQLGrammar1;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class EclipseLinkJpaPlatformFactory
implements JpaPlatformFactory {
    public static final String ID = "org.eclipse.eclipselink.platform";
    public static final String VERSION = "1.0";
    public static final String GROUP_ID = "eclipselink";

    public JpaPlatform buildJpaPlatform(JpaPlatform.Config config) {
        return new GenericJpaPlatform(config, this.buildJpaVersion(config.getJpaFacetVersion()), (JpaFactory)new EclipseLinkJpaFactory(), this.buildAnnotationProvider(), EclipseLinkJpaPlatformProvider.instance(), this.buildJpaPlatformVariation(), EclipseLinkJPQLGrammar1.instance());
    }

    private JpaPlatform.Version buildJpaVersion(IProjectFacetVersion jpaFacetVersion) {
        return new EclipseLinkJpaPlatformVersion(VERSION, jpaFacetVersion.getVersionString());
    }

    protected AnnotationProvider buildAnnotationProvider() {
        return new JpaAnnotationProvider(new JpaAnnotationDefinitionProvider[]{GenericJpaAnnotationDefinitionProvider.instance(), EclipseLinkJpaAnnotationDefinitionProvider.instance()});
    }

    protected JpaPlatformVariation buildJpaPlatformVariation() {
        return new JpaPlatformVariation(){

            public JpaPlatformVariation.Supported getTablePerConcreteClassInheritanceIsSupported() {
                return JpaPlatformVariation.Supported.NO;
            }

            public boolean isJoinTableOverridable() {
                return false;
            }

            public AccessType[] getSupportedAccessTypes(JptResourceType resourceType) {
                return GENERIC_SUPPORTED_ACCESS_TYPES;
            }
        };
    }

    public static class EclipseLinkJpaPlatformVersion
    extends GenericJpaPlatformFactory.GenericJpaPlatformVersion {
        protected final String eclipseLinkVersion;

        public EclipseLinkJpaPlatformVersion(String eclipseLinkVersion, String jpaVersion) {
            super(jpaVersion);
            this.eclipseLinkVersion = eclipseLinkVersion;
        }

        public String getVersion() {
            return this.eclipseLinkVersion;
        }

        public boolean isCompatibleWithEclipseLinkVersion(String version) {
            return VersionComparator.INTEGER_VERSION_COMPARATOR.compare(this.eclipseLinkVersion, version) >= 0;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "/EclipseLink " + this.eclipseLinkVersion;
        }
    }
}

