/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.Arrays;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.EclipseLinkConvertValidator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConvertAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaConvert
extends AbstractJavaConverter
implements EclipseLinkConvert {
    private final ConvertAnnotation convertAnnotation;
    private String specifiedConverterName;
    private String defaultConverterName;

    public EclipseLinkJavaConvert(Converter.ParentAdapter<JavaAttributeMapping> parentAdapter, ConvertAnnotation convertAnnotation) {
        super(parentAdapter);
        this.convertAnnotation = convertAnnotation;
        this.specifiedConverterName = convertAnnotation.getValue();
    }

    public ConvertAnnotation getConverterAnnotation() {
        return this.convertAnnotation;
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedConverterName_(this.convertAnnotation.getValue());
    }

    public void update() {
        super.update();
        this.setDefaultConverterName(this.buildDefaultConverterName());
    }

    @Override
    public String getConverterName() {
        return this.specifiedConverterName != null ? this.specifiedConverterName : this.defaultConverterName;
    }

    @Override
    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    @Override
    public void setSpecifiedConverterName(String name) {
        this.convertAnnotation.setValue(name);
        this.setSpecifiedConverterName_(name);
    }

    protected void setSpecifiedConverterName_(String name) {
        String old = this.specifiedConverterName;
        this.specifiedConverterName = name;
        this.firePropertyChanged("specifiedConverterName", old, name);
    }

    @Override
    public String getDefaultConverterName() {
        return this.defaultConverterName;
    }

    protected void setDefaultConverterName(String name) {
        String old = this.defaultConverterName;
        this.defaultConverterName = name;
        this.firePropertyChanged("defaultConverterName", old, name);
    }

    protected String buildDefaultConverterName() {
        return "none";
    }

    public Class<? extends Converter> getType() {
        return EclipseLinkConvert.class;
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.convertValueTouches(pos) && (result = this.getJavaCandidateConverterNames()) != null) {
            return result;
        }
        return null;
    }

    protected boolean convertValueTouches(int pos) {
        return this.convertAnnotation.valueTouches(pos);
    }

    protected Iterable<String> getJavaCandidateConverterNames() {
        return new TransformationIterable(this.getConverterNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getConverterNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getPersistenceUnit().getUniqueConverterNames(), Arrays.asList(EclipseLinkConvert.RESERVED_CONVERTER_NAMES)});
    }

    @Override
    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<? extends Converter> getConverterType() {
            return EclipseLinkConvert.class;
        }

        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.Convert";
        }

        public JavaConverter buildConverter(Annotation converterAnnotation, JavaAttributeMapping parent, JpaFactory factory) {
            return new EclipseLinkJavaConvert((Converter.ParentAdapter<JavaAttributeMapping>)this.buildConverterParentAdapter(parent), (ConvertAnnotation)converterAnnotation);
        }

        protected JavaConverter.ParentAdapter buildConverterParentAdapter(JavaAttributeMapping parent) {
            return new ConverterParentAdapter(parent);
        }

        public static class ConverterParentAdapter
        implements JavaConverter.ParentAdapter {
            private final JavaAttributeMapping parent;

            public ConverterParentAdapter(JavaAttributeMapping parent) {
                this.parent = parent;
            }

            public JavaAttributeMapping getConverterParent() {
                return this.parent;
            }

            public JpaValidator buildValidator(Converter converter) {
                return new EclipseLinkConvertValidator((EclipseLinkConvert)converter);
            }
        }
    }
}

