/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.ISDKListener;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKCorePlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.core.XMLMemento;
import org.osgi.framework.Version;

public final class SDKManager {
    private static final byte EVENT_ADDED = 0;
    private static final byte EVENT_CHANGED = 1;
    private static final byte EVENT_REMOVED = 2;
    private static SDKManager instance;
    private boolean initialized = false;
    private ArrayList<SDK> sdkList;
    protected List<ISDKListener> sdkListeners = new ArrayList<ISDKListener>(3);

    public static SDKManager getInstance() {
        if (instance == null) {
            instance = new SDKManager();
        }
        return instance;
    }

    public static Version getLeastValidVersion() {
        return ISDKConstants.LEAST_SUPPORTED_SDK_VERSION;
    }

    private SDKManager() {
        instance = this;
    }

    public void addSDK(SDK sdk) {
        if (!this.initialized) {
            this.initialize();
        }
        this.sdkList.add(sdk);
        if (this.sdkList.size() == 1) {
            sdk.setDefault(true);
        }
        this.saveSDKs();
        this.fireSDKEvent(new SDK[]{sdk}, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSDKListener(ISDKListener listener) {
        List<ISDKListener> list = this.sdkListeners;
        synchronized (list) {
            this.sdkListeners.add(listener);
        }
    }

    public boolean containsSDK(SDK theSDK) {
        if (theSDK != null && this.getSDKs().length > 0) {
            SDK[] sDKArray = this.getSDKs();
            int n = sDKArray.length;
            int n2 = 0;
            while (n2 < n) {
                SDK sdk = sDKArray[n2];
                if (theSDK.equals(sdk)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void fireSDKEvent(SDK[] sdks, byte event) {
        if (!this.sdkListeners.isEmpty()) {
            ArrayList<ISDKListener> clone = new ArrayList<ISDKListener>();
            clone.addAll(this.sdkListeners);
            for (ISDKListener listener : clone) {
                try {
                    if (event == 0) {
                        listener.sdksAdded(sdks);
                        continue;
                    }
                    if (event == 1) {
                        listener.sdksChanged(sdks);
                        continue;
                    }
                    if (event != 2) continue;
                    listener.sdksRemoved(sdks);
                }
                catch (Exception e) {
                    SDKCorePlugin.logError("error in sdk listener.", e);
                }
            }
        }
    }

    public SDK getDefaultSDK() {
        SDK[] sDKArray = this.getSDKs();
        int n = sDKArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            if (sdk.isDefault()) {
                return sdk;
            }
            ++n2;
        }
        return null;
    }

    private IEclipsePreferences getPrefs() {
        return new InstanceScope().getNode("com.liferay.ide.eclipse.sdk");
    }

    public SDK getSDK(IPath sdkLocation) {
        SDK[] sDKArray = this.getSDKs();
        int n = sDKArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            if (sdk.getLocation().equals((Object)sdkLocation)) {
                return sdk;
            }
            ++n2;
        }
        return null;
    }

    public SDK getSDK(String sdkName) {
        if (sdkName == null) {
            return null;
        }
        SDK[] sDKArray = this.getSDKs();
        int n = sDKArray.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            if (sdkName.equals(sdk.getName())) {
                return sdk;
            }
            ++n2;
        }
        return null;
    }

    public SDK[] getSDKs() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.sdkList.toArray(new SDK[0]);
    }

    private void initialize() {
        this.loadSDKs();
        this.initialized = true;
    }

    private void loadSDKs() {
        this.sdkList = new ArrayList();
        IEclipsePreferences prefs = this.getPrefs();
        String sdksXmlString = prefs.get("sdks", null);
        if (!CoreUtil.isNullOrEmpty((String)sdksXmlString)) {
            try {
                XMLMemento root = XMLMemento.createReadRoot((Reader)new InputStreamReader(new ByteArrayInputStream(sdksXmlString.getBytes("UTF-8"))));
                String defaultSDKName = root.getString("default");
                XMLMemento[] children = root.getChildren("sdk");
                SDK defaultSDK = null;
                XMLMemento[] xMLMementoArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean def;
                    XMLMemento sdkElement = xMLMementoArray[n2];
                    SDK sdk = new SDK();
                    sdk.loadFromMemento(sdkElement);
                    boolean bl = def = sdk.getName() != null && sdk.getName().equals(defaultSDKName) && defaultSDK == null;
                    if (def) {
                        sdk.setDefault(def);
                        defaultSDK = sdk;
                    }
                    this.sdkList.add(sdk);
                    ++n2;
                }
            }
            catch (Exception e) {
                SDKCorePlugin.logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSDKListener(ISDKListener listener) {
        List<ISDKListener> list = this.sdkListeners;
        synchronized (list) {
            this.sdkListeners.remove(listener);
        }
    }

    private void saveSDKs() {
        XMLMemento root = XMLMemento.createWriteRoot((String)"sdks");
        for (SDK sdk : this.sdkList) {
            XMLMemento child = root.createChild("sdk");
            sdk.saveToMemento(child);
            if (!sdk.isDefault()) continue;
            root.putString("default", sdk.getName());
        }
        try {
            StringWriter writer = new StringWriter();
            root.save((Writer)writer);
            this.getPrefs().put("sdks", writer.toString());
            this.getPrefs().flush();
        }
        catch (Exception e) {
            LiferayCore.logError((Throwable)e);
        }
    }

    public void saveSDKs(SDK[] sdks) {
        this.setSDKs(sdks);
    }

    public void setSDKs(SDK[] sdks) {
        this.sdkList.clear();
        SDK[] sDKArray = sdks;
        int n = sdks.length;
        int n2 = 0;
        while (n2 < n) {
            SDK sdk = sDKArray[n2];
            this.sdkList.add(sdk);
            ++n2;
        }
        this.saveSDKs();
        this.fireSDKEvent(sdks, (byte)1);
    }
}

