/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.descriptor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.DescriptorHelper;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.project.core.BaseValidator;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayDisplayDescriptorValidator
extends BaseValidator {
    public static final String CATEGORY_ELEMENT = "category";
    public static final String MARKER_TYPE = "com.liferay.ide.portlet.core.liferayDisplayDescriptorMarker";
    public static final String MESSAGE_CATEGORY_NAME_IS_EMPTY = Msgs.categoryNameCannotBeEmpty;
    public static final String MESSAGE_PORTLET_NAME_NOT_FOUND = Msgs.portletIdNotMatchPortletName;
    public static final String PORTLET_ELEMENT = "portlet";
    public static final String PORTLET_NAME_ELEMENT = "portlet-name";
    public static final String PREFERENCE_NODE_QUALIFIER = LiferayProjectCore.getDefault().getBundle().getSymbolicName();

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile liferayDisplayXml = (IFile)resource;
        IFile portletXml = DescriptorHelper.getDescriptorFile((IProject)liferayDisplayXml.getProject(), (String)"portlet.xml");
        if (liferayDisplayXml.isAccessible() && portletXml != null && portletXml.isAccessible() && ProjectUtil.isPortletProject((IProject)resource.getProject())) {
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(liferayDisplayXml.getProject());
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(liferayDisplayXml, portletXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
                if (problems.length > 0 && portletXml != null && portletXml.exists()) {
                    result.setDependsOn(new IResource[]{portletXml});
                }
            }
            catch (Exception e) {
                PortletCore.logError(e);
            }
        }
        return result;
    }

    protected void checkCategoryName(IDOMDocument liferayDisplayDocument, Node categoryNameNode, IScopeContext[] preferenceScopes, String validationKey, String errorMessage, List<Map<String, Object>> problems) {
        String msg;
        Map problem;
        String categoryNameValue;
        Node categoryName = categoryNameNode.getAttributes().getNamedItem("name");
        if (categoryName != null && (categoryNameValue = categoryName.getNodeValue()).matches("\\s*") && (problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey, (IDOMNode)categoryName, msg = MessageFormat.format(errorMessage, categoryNameValue))) != null) {
            problems.add(problem);
        }
    }

    protected void checkCategoryNames(IDOMDocument liferayDisplayDocument, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        NodeList elements = liferayDisplayDocument.getElementsByTagName(CATEGORY_ELEMENT);
        int i = 0;
        while (i < elements.getLength()) {
            Node categoryElement = elements.item(i);
            this.checkCategoryName(liferayDisplayDocument, categoryElement, preferenceScopes, "validation-liferay-display-xml-category-name-invalid", MESSAGE_CATEGORY_NAME_IS_EMPTY, problems);
            ++i;
        }
    }

    protected void checkPortletId(IDOMDocument portletXmlDocument, Node portletIdNode, IScopeContext[] preferenceScopes, String validationKey, String errorMessage, List<Map<String, Object>> problems) {
        NodeList elements = portletXmlDocument.getElementsByTagName(PORTLET_NAME_ELEMENT);
        Node portletId = portletIdNode.getAttributes().getNamedItem("id");
        if (portletId != null) {
            String msg;
            Map problem;
            String portletIdValue = portletId.getNodeValue();
            boolean portletNameFound = false;
            int i = 0;
            while (i < elements.getLength()) {
                Node item = elements.item(i);
                String portletName = NodeUtil.getTextContent((Node)item);
                if (CoreUtil.isEqual((Object)portletName, (Object)portletIdValue)) {
                    portletNameFound = true;
                    break;
                }
                ++i;
            }
            if (!portletNameFound && (problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey, (IDOMNode)portletIdNode, msg = MessageFormat.format(errorMessage, portletIdValue))) != null) {
                problems.add(problem);
            }
        }
    }

    protected void checkPortletIds(IDOMDocument liferayDisplayDocument, IDOMDocument portletXmlDocument, IScopeContext[] preferenceScopes, List<Map<String, Object>> problems) {
        NodeList elements = liferayDisplayDocument.getElementsByTagName(PORTLET_ELEMENT);
        int i = 0;
        while (i < elements.getLength()) {
            Node portletElement = elements.item(i);
            this.checkPortletId(portletXmlDocument, portletElement, preferenceScopes, "validation-liferay-display-xml-portlet-id-not-found", MESSAGE_PORTLET_NAME_NOT_FOUND, problems);
            ++i;
        }
    }

    protected Map<String, Object>[] detectProblems(IFile liferayDisplayXml, IFile portletXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map<String, Object>> problems;
        block13: {
            problems = new ArrayList<Map<String, Object>>();
            IStructuredModel liferayDisplayModel = null;
            IStructuredModel portletXmlModel = null;
            IDOMDocument liferayDisplayDocument = null;
            try {
                try {
                    liferayDisplayModel = StructuredModelManager.getModelManager().getModelForRead(liferayDisplayXml);
                    if (liferayDisplayModel != null && liferayDisplayModel instanceof IDOMModel) {
                        liferayDisplayDocument = ((IDOMModel)liferayDisplayModel).getDocument();
                        if (portletXml != null && portletXml.exists() && (portletXmlModel = StructuredModelManager.getModelManager().getModelForRead(portletXml)) instanceof IDOMModel) {
                            IDOMDocument portletXmlDocument = ((IDOMModel)portletXmlModel).getDocument();
                            this.checkPortletIds(liferayDisplayDocument, portletXmlDocument, preferenceScopes, problems);
                            this.checkCategoryNames(liferayDisplayDocument, preferenceScopes, problems);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (liferayDisplayModel != null) {
                        liferayDisplayModel.releaseFromRead();
                    }
                    if (portletXmlModel != null) {
                        portletXmlModel.releaseFromRead();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (liferayDisplayModel != null) {
                    liferayDisplayModel.releaseFromRead();
                }
                if (portletXmlModel != null) {
                    portletXmlModel.releaseFromRead();
                }
                throw throwable;
            }
            if (liferayDisplayModel != null) {
                liferayDisplayModel.releaseFromRead();
            }
            if (portletXmlModel != null) {
                portletXmlModel.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    private static class Msgs
    extends NLS {
        public static String categoryNameCannotBeEmpty;
        public static String portletIdNotMatchPortletName;

        static {
            Msgs.initializeMessages((String)LiferayDisplayDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

