/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class J2EEVersionUtil {
    public static String getServletTextVersion(int aVersion) {
        switch (aVersion) {
            case 22: {
                return "2.2";
            }
            case 23: {
                return "2.3";
            }
            case 24: {
                return "2.4";
            }
            case 25: {
                return "2.5";
            }
            case 30: {
                return "3.0";
            }
            case 31: {
                return "3.1";
            }
        }
        return "";
    }

    public static String getEJBTextVersion(int aVersion) {
        switch (aVersion) {
            case 10: {
                return "1.0";
            }
            case 11: {
                return "1.1";
            }
            case 20: {
                return "2.0";
            }
            case 21: {
                return "2.1";
            }
            case 30: {
                return "3.0";
            }
            case 31: {
                return "3.1";
            }
            case 32: {
                return "3.2";
            }
        }
        return "";
    }

    public static String getJCATextVersion(int aVersion) {
        switch (aVersion) {
            case 10: {
                return "1.0";
            }
            case 15: {
                return "1.5";
            }
            case 16: {
                return "1.6";
            }
            case 17: {
                return "1.7";
            }
        }
        return "";
    }

    public static String getJ2EETextVersion(int aVersion) {
        switch (aVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
            case 50: {
                return "5.0";
            }
            case 60: {
                return "6.0";
            }
            case 70: {
                return "7.0";
            }
        }
        return "";
    }

    public static int convertAppClientVersionStringToJ2EEVersionID(String version) {
        if (version.equals("1.2")) {
            return 12;
        }
        if (version.equals("1.3")) {
            return 13;
        }
        if (version.equals("1.4")) {
            return 14;
        }
        if (version.equals("5.0")) {
            return 50;
        }
        if (version.equals("6.0")) {
            return 60;
        }
        if (version.equals("7.0")) {
            return 70;
        }
        return 50;
    }

    public static int convertEJBVersionStringToJ2EEVersionID(String version) {
        if (version.equals("1.1")) {
            return 12;
        }
        if (version.equals("2.0")) {
            return 13;
        }
        if (version.equals("2.1")) {
            return 14;
        }
        if (version.equals("3.0")) {
            return 50;
        }
        if (version.equals("3.1")) {
            return 60;
        }
        if (version.equals("3.2")) {
            return 70;
        }
        return 50;
    }

    public static int convertWebVersionStringToJ2EEVersionID(String version) {
        if (version.equals("2.2")) {
            return 12;
        }
        if (version.equals("2.3")) {
            return 13;
        }
        if (version.equals("2.4")) {
            return 14;
        }
        if (version.equals("2.5")) {
            return 50;
        }
        if (version.equals("3.0")) {
            return 60;
        }
        if (version.equals("3.1")) {
            return 70;
        }
        return 14;
    }

    public static int convertWebFragmentVersionStringToJ2EEVersionID(String version) {
        return 60;
    }

    public static int convertConnectorVersionStringToJ2EEVersionID(String version) {
        if (version.equals("1.0")) {
            return 13;
        }
        if (version.equals("1.5")) {
            return 14;
        }
        if (version.equals("1.6")) {
            return 60;
        }
        return 60;
    }

    public static int convertJ2EEVersionIDToEJBVersionID(int j2eeVersionId) {
        switch (j2eeVersionId) {
            case 12: {
                return 11;
            }
            case 13: {
                return 20;
            }
            case 14: {
                return 21;
            }
            case 50: {
                return 30;
            }
            case 60: {
                return 31;
            }
            case 70: {
                return 32;
            }
        }
        return 31;
    }

    public static int convertJ2EEVersionIDToWebVersionID(int j2eeVersionId) {
        switch (j2eeVersionId) {
            case 12: {
                return 22;
            }
            case 13: {
                return 23;
            }
            case 14: {
                return 24;
            }
            case 50: {
                return 25;
            }
            case 60: {
                return 30;
            }
            case 70: {
                return 31;
            }
        }
        return 30;
    }

    public static int convertJ2EEVersionIDToConnectorVersionID(int j2eeVersionId) {
        switch (j2eeVersionId) {
            case 13: {
                return 10;
            }
            case 14: 
            case 50: {
                return 15;
            }
            case 60: {
                return 16;
            }
            case 70: {
                return 17;
            }
        }
        return 16;
    }

    public static int convertVersionStringToInt(IVirtualComponent comp) {
        String version = J2EEProjectUtilities.getJ2EEProjectVersion(comp.getProject());
        if (JavaEEProjectUtilities.isDynamicWebProject(comp.getProject())) {
            return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID(version);
        }
        if (JavaEEProjectUtilities.isEJBProject(comp.getProject())) {
            return J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID(version);
        }
        if (JavaEEProjectUtilities.isEARProject(comp.getProject())) {
            return J2EEVersionUtil.convertVersionStringToInt(version);
        }
        if (JavaEEProjectUtilities.isJCAProject(comp.getProject())) {
            return J2EEVersionUtil.convertConnectorVersionStringToJ2EEVersionID(version);
        }
        if (JavaEEProjectUtilities.isApplicationClientProject(comp.getProject())) {
            return J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID(version);
        }
        return 0;
    }

    public static int convertVersionStringToInt(String version) {
        int nVersion = 0;
        if ("1.0".equals(version)) {
            nVersion = 10;
        } else if ("1.1".equals(version)) {
            nVersion = 11;
        } else if ("1.2".equals(version)) {
            nVersion = 12;
        } else if ("1.3".equals(version)) {
            nVersion = 13;
        } else if ("1.4".equals(version)) {
            nVersion = 14;
        } else if ("1.5".equals(version)) {
            nVersion = 15;
        } else if ("1.6".equals(version)) {
            nVersion = 16;
        } else if ("1.7".equals(version)) {
            nVersion = 17;
        } else if ("2.0".equals(version)) {
            nVersion = 20;
        } else if ("2.1".equals(version)) {
            nVersion = 21;
        } else if ("2.2".equals(version)) {
            nVersion = 22;
        } else if ("2.3".equals(version)) {
            nVersion = 23;
        } else if ("2.4".equals(version)) {
            nVersion = 24;
        } else if ("2.5".equals(version)) {
            nVersion = 25;
        } else if ("3.0".equals(version)) {
            nVersion = 30;
        } else if ("3.1".equals(version)) {
            nVersion = 31;
        } else if ("3.2".equals(version)) {
            nVersion = 32;
        } else if ("5.0".equals(version)) {
            nVersion = 50;
        } else if ("6.0".equals(version)) {
            nVersion = 60;
        } else if ("7.0".equals(version)) {
            nVersion = 70;
        }
        return nVersion;
    }

    public static String convertVersionIntToString(int version) {
        String nVersion = null;
        if (version == 10) {
            nVersion = "1.0";
        } else if (version == 11) {
            nVersion = "1.1";
        } else if (version == 12) {
            nVersion = "1.2";
        } else if (version == 13) {
            nVersion = "1.3";
        } else if (version == 14) {
            nVersion = "1.4";
        } else if (version == 15) {
            nVersion = "1.5";
        } else if (version == 16) {
            nVersion = "1.6";
        } else if (version == 17) {
            nVersion = "1.7";
        } else if (version == 20) {
            nVersion = "2.0";
        } else if (version == 21) {
            nVersion = "2.1";
        } else if (version == 22) {
            nVersion = "2.2";
        } else if (version == 23) {
            nVersion = "2.3";
        } else if (version == 24) {
            nVersion = "2.4";
        } else if (version == 25) {
            nVersion = "2.5";
        } else if (version == 30) {
            nVersion = "3.0";
        } else if (version == 31) {
            nVersion = "3.1";
        } else if (version == 32) {
            nVersion = "3.2";
        } else if (version == 50) {
            nVersion = "5.0";
        } else if (version == 60) {
            nVersion = "6.0";
        } else if (version == 70) {
            nVersion = "7.0";
        }
        return nVersion;
    }
}

