/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;

public final class WorkspaceUtil {
    private static final Logger log = JSFUICommonPlugin.getLogger(WorkspaceUtil.class);

    private WorkspaceUtil() {
    }

    public static void ensureExistsInWorkspace(final IFile resource, final InputStream contents) {
        if (resource == null) {
            return;
        }
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (resource.exists()) {
                    resource.setContents(contents, true, false, null);
                } else {
                    WorkspaceUtil.ensureExistsInWorkspace((IResource)resource.getParent(), true);
                    resource.create(contents, true, null);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            log.error("Test.EclipseWorkspaceTest.Error.FileCreationInWorkspace", resource.getName(), e);
        }
    }

    public static void ensureExistsInWorkspace(IFile resource, String contents) {
        WorkspaceUtil.ensureExistsInWorkspace(resource, new ByteArrayInputStream(contents.getBytes()));
    }

    public static void ensureExistsInWorkspace(final IResource resource, final boolean local) {
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                WorkspaceUtil.create(resource, local);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(body, null);
        }
        catch (CoreException e) {
            log.error("Test.EclipseWorkspaceTest.Error.ResourceCreationInWorkspace", resource.getName(), e);
        }
    }

    protected static void create(IResource resource, boolean local) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            WorkspaceUtil.create((IResource)resource.getParent(), local);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)(local ? new ByteArrayInputStream(new byte[0]) : null), true, WorkspaceUtil.getMonitor());
                break;
            }
            case 2: {
                ((IFolder)resource).create(true, local, WorkspaceUtil.getMonitor());
                break;
            }
            case 4: {
                ((IProject)resource).create(WorkspaceUtil.getMonitor());
                ((IProject)resource).open(WorkspaceUtil.getMonitor());
            }
        }
    }

    public static IProgressMonitor getMonitor() {
        return new NullProgressMonitor();
    }

    public static IProject getProjectFor(IPath path) {
        IResource res;
        String[] segs = path.segments();
        String projectPath = new String();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject project = null;
        int p = 0;
        while (p < projects.length) {
            if (projects[p].isOpen()) {
                int s = 0;
                while (s < segs.length) {
                    if (segs[s].equalsIgnoreCase(projects[p].getName())) {
                        int s2 = s + 1;
                        while (s2 < segs.length) {
                            projectPath = String.valueOf(projectPath) + "/" + segs[s2];
                            ++s2;
                        }
                        project = projects[p];
                        break;
                    }
                    ++s;
                }
            }
            ++p;
        }
        if (project == null) {
            return null;
        }
        if (!project.getWorkspace().isTreeLocked()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                JSFUICommonPlugin.getLogger(WorkspaceUtil.class).info("Error.RefreshingLocal", e);
            }
        }
        if ((res = project.findMember((IPath)new Path(projectPath))) != null && res.exists()) {
            return project;
        }
        return null;
    }

    public static IProject getProjectFor(IFile file) {
        Path testPath = new Path(file.getFullPath().toOSString());
        return WorkspaceUtil.getProjectFor((IPath)testPath);
    }

    public static IProject getProjectFor(File file) {
        Path testPath = new Path(file.getAbsolutePath());
        return WorkspaceUtil.getProjectFor((IPath)testPath);
    }

    public static IResource getProjectRelativeResource(IPath path) {
        String[] segs = path.segments();
        String projectPath = new String();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject project = null;
        int p = 0;
        while (p < projects.length) {
            if (projects[p].isOpen()) {
                int s = 0;
                while (s < segs.length) {
                    if (segs[s].equalsIgnoreCase(projects[p].getName())) {
                        int s2 = s + 1;
                        while (s2 < segs.length) {
                            projectPath = String.valueOf(projectPath) + "/" + segs[s2];
                            ++s2;
                        }
                        project = projects[p];
                        break;
                    }
                    ++s;
                }
            }
            ++p;
        }
        if (project == null) {
            return null;
        }
        return project.getFile(projectPath);
    }

    public static IResource getProjectRelativeResource(File file) {
        Path testPath = new Path(file.getAbsolutePath());
        return WorkspaceUtil.getProjectRelativeResource((IPath)testPath);
    }
}

