/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.sdk.ui.AddSDKDialog;
import com.liferay.ide.sdk.ui.SDKUIPlugin;
import com.liferay.ide.ui.util.SWTUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InstalledSDKsCompostite
extends Composite {
    protected Button fAddButton;
    protected Button fEditButton;
    protected Button fOpenInEclipse;
    protected ISelection fPrevSelection;
    protected Button fRemoveButton;
    protected PreferencePage page;
    protected List<SDK> sdks = null;
    protected Table table;
    protected CheckboxTableViewer tableViewer;

    public InstalledSDKsCompostite(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(2, false);
        this.setLayout((Layout)gl);
        this.createControl(this);
    }

    protected void addSDK() {
        AddSDKDialog dialog = new AddSDKDialog(this.getShell(), this.getSDKs());
        int retval = dialog.open();
        if (retval == 0) {
            String name = dialog.getName();
            SDK newSDK = SDKUtil.createSDKFromLocation((IPath)new Path(dialog.getLocation()));
            newSDK.setName(name);
            if (dialog.getAddProject()) {
                newSDK.addProjectFile();
                if (dialog.getOpenInEclipse()) {
                    this.openInEclipse(newSDK);
                }
            }
            this.sdks.add(newSDK);
            this.ensureDefaultSDK();
            this.tableViewer.refresh();
        }
    }

    protected void createControl(Composite parent) {
        SWTUtil.createLabel((Composite)parent, (String)Msgs.installedLiferayPluginSDKsLabel, (int)2);
        this.table = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.table.setLayoutData((Object)gd);
        this.table.setFont(parent.getFont());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(Msgs.name);
        int defaultwidth = gd.widthHint / 3 + 1;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.table, 0);
        column.setText(Msgs.version);
        column.setWidth(defaultwidth - 60);
        column = new TableColumn(this.table, 0);
        column.setText(Msgs.location);
        column.setWidth(defaultwidth + 90);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SDKLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new SDKContentProvider());
        this.tableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return ((SDK)element).isDefault();
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledSDKsCompostite.this.enableButtons();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledSDKsCompostite.this.setCheckedSDK((SDK)event.getElement());
                } else {
                    InstalledSDKsCompostite.this.setCheckedSDK(null);
                }
            }
        });
        Composite buttons = SWTUtil.createComposite((Composite)parent, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTUtil.createPushButton((Composite)buttons, (String)Msgs.add, null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSDKsCompostite.this.addSDK();
            }
        });
        this.fEditButton = SWTUtil.createPushButton((Composite)buttons, (String)Msgs.edit, null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSDKsCompostite.this.editSDK(InstalledSDKsCompostite.this.getFirstSelectedSDK());
            }
        });
        this.fRemoveButton = SWTUtil.createPushButton((Composite)buttons, (String)Msgs.remove, null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSDKsCompostite.this.removeSelectedSDKs();
            }
        });
        this.fOpenInEclipse = SWTUtil.createPushButton((Composite)buttons, (String)Msgs.openInEclipse, null);
        this.fOpenInEclipse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledSDKsCompostite.this.openInEclipse(InstalledSDKsCompostite.this.getFirstSelectedSDK());
            }
        });
        SDK[] sdks = SDKManager.getInstance().getSDKs();
        SDK[] editableSDKs = new SDK[sdks.length];
        int i = 0;
        while (i < sdks.length) {
            editableSDKs[i] = sdks[i].copy();
            ++i;
        }
        this.setSDKs(editableSDKs);
        this.enableButtons();
        this.fAddButton.setEnabled(true);
    }

    protected void editSDK(SDK sdk) {
        AddSDKDialog dialog = new AddSDKDialog(this.getShell(), this.getSDKs(), sdk);
        int retval = dialog.open();
        if (retval == 0) {
            String newName = dialog.getName();
            String newLocation = dialog.getLocation();
            sdk.setName(newName);
            sdk.setLocation((IPath)new Path(newLocation));
            if (dialog.getAddProject()) {
                sdk.addProjectFile();
                if (dialog.getOpenInEclipse()) {
                    this.openInEclipse(sdk);
                }
            }
            this.tableViewer.refresh();
            this.ensureDefaultSDK();
            this.tableViewer.refresh();
        }
    }

    protected void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        int selectionCount = selection.size();
        if (selectionCount > 0 && selectionCount <= this.tableViewer.getTable().getItemCount()) {
            for (SDK install : selection) {
                if (!this.isContributed(install)) continue;
                this.fEditButton.setEnabled(false);
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fEditButton.setEnabled(true);
            this.fRemoveButton.setEnabled(true);
            this.fOpenInEclipse.setEnabled(true);
        } else {
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fOpenInEclipse.setEnabled(false);
        }
    }

    protected void ensureDefaultSDK() {
        if (this.sdks.size() == 1) {
            this.sdks.get(0).setDefault(true);
        }
    }

    protected void fireSelectionChanged() {
    }

    public SDK getDefaultSDK() {
        ArrayList<SDK> sdkList = new ArrayList<SDK>();
        for (SDK sdk : this.sdks) {
            if (!sdk.isDefault()) continue;
            sdkList.add(sdk);
        }
        if (sdkList.size() == 1) {
            return (SDK)sdkList.get(0);
        }
        return null;
    }

    protected SDK getFirstSelectedSDK() {
        Object next;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator iterator = selection.iterator();
        if (iterator.hasNext() && (next = iterator.next()) instanceof SDK) {
            return (SDK)next;
        }
        return null;
    }

    public SDK[] getSDKs() {
        return this.sdks.toArray(new SDK[0]);
    }

    private ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    protected boolean isContributed(SDK install) {
        return install.isContributed();
    }

    protected void openInEclipse(SDK sdk) {
        IProject sdkProject;
        if (!sdk.hasProjectFile()) {
            sdk.addProjectFile();
        }
        if ((sdkProject = CoreUtil.getProject((String)sdk.getName())) == null || !sdkProject.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(sdk.getName());
            description.setLocationURI(sdk.getLocation().toFile().toURI());
            NullProgressMonitor npm = new NullProgressMonitor();
            try {
                sdkProject.create(description, (IProgressMonitor)npm);
                sdkProject.open((IProgressMonitor)npm);
            }
            catch (Exception e) {
                SDKUIPlugin.logError(e);
            }
        }
    }

    protected void removeSDKs(SDK[] removeSdks) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < removeSdks.length) {
            this.sdks.remove(removeSdks[i]);
            ++i;
        }
        this.ensureDefaultSDK();
        this.tableViewer.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            SDK[] curSdks = this.getSDKs();
            if (curr.size() == 0 && curSdks.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)curSdks[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
        this.tableViewer.refresh();
        if (this.page != null) {
            this.page.getContainer().updateButtons();
        }
    }

    protected void removeSelectedSDKs() {
        IProject[] projects;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        SDK[] selectedSdks = new SDK[selection.size()];
        Iterator iterator = selection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            SDK sdk = null;
            Object next = iterator.next();
            if (next instanceof SDK) {
                sdk = (SDK)next;
            } else if (next instanceof IStructuredSelection) {
                sdk = (SDK)((IStructuredSelection)next).getFirstElement();
            }
            selectedSdks[i++] = sdk;
        }
        List<SDK> sdksList = Arrays.asList(selectedSdks);
        ArrayList<SDK> sdksToRemove = new ArrayList<SDK>();
        sdksToRemove.addAll(sdksList);
        ArrayList<SDK> checkedSDks = new ArrayList<SDK>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            SDK sdk = SDKUtil.getSDK((IProject)project);
            if (sdksList.contains(sdk) && !checkedSDks.contains(sdk)) {
                boolean remove = MessageDialog.openQuestion((Shell)this.getShell(), (String)Msgs.installedSDKs, (String)MessageFormat.format(Msgs.sdkRemovalConfirmation, sdk.getName()));
                if (!remove) {
                    sdksToRemove.remove(sdk);
                }
                checkedSDks.add(sdk);
            }
            ++n2;
        }
        this.removeSDKs(sdksToRemove.toArray(new SDK[sdksToRemove.size()]));
    }

    protected void setCheckedSDK(SDK element) {
        if (element != null) {
            SDK[] sDKArray = this.getSDKs();
            int n = sDKArray.length;
            int n2 = 0;
            while (n2 < n) {
                SDK sdk = sDKArray[n2];
                sdk.setDefault(false);
                ++n2;
            }
            element.setDefault(true);
            this.tableViewer.refresh();
        } else {
            SDK[] sDKArray = this.getSDKs();
            int n = sDKArray.length;
            int n3 = 0;
            while (n3 < n) {
                SDK sdk = sDKArray[n3];
                sdk.setDefault(false);
                ++n3;
            }
            this.tableViewer.refresh();
        }
        if (this.page != null) {
            this.page.getContainer().updateButtons();
        }
    }

    public void setPreferencePage(PreferencePage prefPage) {
        this.page = prefPage;
    }

    protected void setSDKs(SDK[] newSdks) {
        this.sdks = new ArrayList<SDK>();
        Collections.addAll(this.sdks, newSdks);
        this.tableViewer.setInput(this.sdks);
        this.tableViewer.refresh();
    }

    protected void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object sdk = ((IStructuredSelection)selection).getFirstElement();
            if (sdk == null) {
                this.tableViewer.setCheckedElements(new Object[0]);
            } else {
                this.tableViewer.setCheckedElements(new Object[]{sdk});
                this.tableViewer.reveal(sdk);
            }
            this.fireSelectionChanged();
        }
    }

    private static class Msgs
    extends NLS {
        public static String add;
        public static String edit;
        public static String installedLiferayPluginSDKsLabel;
        public static String installedSDKs;
        public static String location;
        public static String name;
        public static String openInEclipse;
        public static String remove;
        public static String sdkRemovalConfirmation;
        public static String version;

        static {
            Msgs.initializeMessages((String)InstalledSDKsCompostite.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }

    protected class SDKContentProvider
    implements IStructuredContentProvider {
        protected SDKContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return InstalledSDKsCompostite.this.getSDKs();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class SDKLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected SDKLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return SDKUIPlugin.getDefault().getImage("IMG_ICON_SDK_SMALL");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String retval = null;
            if (element instanceof SDK) {
                SDK sdk = (SDK)element;
                switch (columnIndex) {
                    case 0: {
                        retval = sdk.getName();
                        break;
                    }
                    case 1: {
                        retval = sdk.getVersion();
                        break;
                    }
                    case 2: {
                        retval = sdk.getLocation().toOSString();
                    }
                }
            } else {
                retval = "";
            }
            return retval;
        }
    }
}

