/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.taglib.ui.model.internal;

import com.liferay.ide.taglib.ui.model.Attribute;
import com.liferay.ide.taglib.ui.model.Tag;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.DerivedValueServiceData;

public class PreviewSourceContentProvider
extends DerivedValueService {
    protected DerivedValueServiceData compute() {
        boolean preview = "Preview".equals(((Property)this.context(Property.class)).name());
        Tag tag = (Tag)this.context(Element.class);
        StringBuffer buffer = new StringBuffer();
        String tagName = (String)tag.getName().content();
        String prefix = (String)tag.getPrefix().content();
        if (preview) {
            buffer.append("<span style='color:RGB(64,128,128)'>&lt;");
        } else {
            buffer.append("<");
        }
        buffer.append(String.valueOf(prefix) + ":" + tagName);
        if (preview) {
            buffer.append("</span>");
        }
        for (Attribute attr : tag.getRequiredAttributes()) {
            this.appendAttr(attr, buffer, preview);
        }
        for (Attribute attr : tag.getOtherAttributes()) {
            this.appendAttr(attr, buffer, preview);
        }
        for (Attribute attr : tag.getEvents()) {
            this.appendAttr(attr, buffer, preview);
        }
        if (preview) {
            buffer.append("<span style='color:RGB(64,128,128)'>&gt;&lt;");
        } else {
            buffer.append("><");
        }
        buffer.append("/" + prefix + ":" + tagName);
        if (preview) {
            buffer.append("&gt;</span>");
        } else {
            buffer.append(">");
        }
        return new DerivedValueServiceData(buffer.toString());
    }

    protected void appendAttr(Attribute attr, StringBuffer buffer, boolean preview) {
        String content = (String)attr.getValue().content();
        if (content != null) {
            buffer.append(" ");
            if (preview) {
                buffer.append("<span style='color:RGB(127,0,127)'>");
            }
            buffer.append((String)attr.getName().content());
            if (preview) {
                buffer.append("</span>");
            }
            buffer.append("=");
            if (preview) {
                buffer.append("<span style='color:RGB(42,0,255);font-style:italic'>&quot;");
            } else {
                buffer.append("\"");
            }
            buffer.append(content);
            if (preview) {
                buffer.append("&quot;</span>");
            } else {
                buffer.append("\"");
            }
        }
    }
}

