/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.templates.core;

import com.liferay.ide.templates.core.ITemplateOperation;
import com.liferay.ide.templates.core.TemplateModel;
import com.liferay.ide.templates.core.TemplateOperation;
import com.liferay.ide.templates.core.TemplateVariable;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TemplatesCore
extends Plugin {
    public static final String PLUGIN_ID = "com.liferay.ide.templates.core";
    private static TemplatesCore plugin;
    private static Map<String, TemplateModel> templateModels;
    private static IConfigurationElement[] tplDefinitionElements;

    static {
        templateModels = new HashMap<String, TemplateModel>();
    }

    public static IStatus createErrorStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static TemplatesCore getDefault() {
        return plugin;
    }

    public static ITemplateOperation getTemplateOperation(String templateId) {
        TemplateModel model = TemplatesCore.getTemplateModel(templateId);
        return new TemplateOperation(model);
    }

    public static void logError(Exception e) {
        TemplatesCore.getDefault().getLog().log(TemplatesCore.createErrorStatus(e));
    }

    public static void logError(String msg) {
        TemplatesCore.getDefault().getLog().log(TemplatesCore.createErrorStatus(msg));
    }

    private static TemplateModel createTemplateModel(IConfigurationElement element, String pluginName) {
        TemplateModel templateModel = null;
        try {
            IConfigurationElement[] items;
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String resource = element.getAttribute("resource");
            String templateFolder = null;
            ArrayList<TemplateVariable> paramList = new ArrayList<TemplateVariable>();
            IConfigurationElement[] iConfigurationElementArray = items = ((IExtension)element.getParent()).getConfigurationElements();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement item = iConfigurationElementArray[n2];
                if ("templatesFolder".equals(item.getName())) {
                    templateFolder = item.getAttribute("path");
                }
                if ("templateVariable".equals(item.getName())) {
                    String paramName = item.getAttribute("name");
                    String reqVal = item.getAttribute("required");
                    paramList.add(new TemplateVariable(paramName, reqVal));
                }
                ++n2;
            }
            Configuration config = new Configuration();
            TemplateVariable[] vars = paramList.toArray(new TemplateVariable[0]);
            templateModel = new TemplateModel(pluginName, config, id, name, resource, templateFolder, vars);
        }
        catch (Exception e) {
            TemplatesCore.logError(e);
        }
        return templateModel;
    }

    private static TemplateModel getTemplateModel(String templateId) {
        if (templateId == null) {
            return null;
        }
        TemplateModel model = templateModels.get(templateId);
        if (model == null) {
            IConfigurationElement element = TemplatesCore.getTplDefinitionElement(templateId);
            String pluginName = element.getContributor().getName();
            model = TemplatesCore.createTemplateModel(element, pluginName);
            try {
                TemplatesCore.initializeModel(model);
            }
            catch (Exception e) {
                TemplatesCore.logError(e);
                model = null;
            }
            if (model != null) {
                templateModels.put(templateId, model);
            }
        }
        return model;
    }

    private static IConfigurationElement getTplDefinitionElement(String templateId) {
        IConfigurationElement[] elements;
        if (templateId == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = TemplatesCore.getTplDefinitionElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("template".equals(element.getName()) && templateId.equals(element.getAttribute("id"))) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IConfigurationElement[] getTplDefinitionElements() {
        if (tplDefinitionElements == null) {
            tplDefinitionElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.templates.core.templateDefinition");
        }
        return tplDefinitionElements;
    }

    private static void initializeModel(TemplateModel templateModel) throws Exception {
        Configuration config = templateModel.getConfig();
        String bundleId = templateModel.getBundleId();
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            TemplatesCore.logError("Could not initialize template model: could not find bundle " + bundleId);
        }
        URL loaderRoot = bundle.getEntry(templateModel.getTemplateFolder());
        URL fileUrl = FileLocator.toFileURL((URL)loaderRoot);
        config.setDirectoryForTemplateLoading(new File(fileUrl.getFile().toString()));
        config.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        templateModel.setConfig(config);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

