/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.remote;

import com.liferay.ide.core.remote.APIException;
import com.liferay.ide.debug.core.fm.FMDebugTarget;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.PortalSourceLookupDirector;
import com.liferay.ide.server.remote.IRemoteServer;
import com.liferay.ide.server.remote.IServerManagerConnection;
import com.liferay.ide.server.remote.RemoteMonitorProcess;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class RemoteLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String SERVER_ID = "server-id";

    protected void debugLaunch(IServer server, ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.runLaunch(server, configuration, launch, monitor);
        String connectorId = this.getVMConnectorId(configuration);
        IVMConnector connector = null;
        connector = connectorId == null ? JavaRuntime.getDefaultVMConnector() : JavaRuntime.getVMConnector((String)connectorId);
        if (connector == null) {
            this.abort("Debugging connector not specified.", null, 119);
        }
        Map connectMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
        int connectTimeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        connectMap.put("timeout", "" + connectTimeout);
        if (monitor.isCanceled()) {
            return;
        }
        PortalSourceLookupDirector sourceLocator = new PortalSourceLookupDirector(configuration, "com.liferay.ide.server.tomcat.portalSourcePathComputer");
        sourceLocator.configureLaunch(launch);
        if (!launch.isTerminated()) {
            connector.connect(connectMap, monitor, launch);
        }
        if (monitor.isCanceled() || launch.isTerminated()) {
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            int i = 0;
            while (i < debugTargets.length) {
                IDebugTarget target = debugTargets[i];
                if (target.canDisconnect()) {
                    target.disconnect();
                }
                ++i;
            }
            return;
        }
        IServerManagerConnection connection = this.getServerManagerConnection(server, monitor);
        if (connection != null) {
            try {
                String fmDebugPassword = connection.getFMDebugPassword();
                int fmDebugPort = connection.getFMDebugPort();
                if (fmDebugPassword != null && fmDebugPort != -1) {
                    launch.setAttribute("fm-debug-password", fmDebugPassword);
                    launch.setAttribute("fm-debug-port", Integer.toString(fmDebugPort));
                    FMDebugTarget target = new FMDebugTarget(server.getHost(), launch, launch.getProcesses()[0]);
                    launch.addDebugTarget((IDebugTarget)target);
                }
            }
            catch (APIException e) {
                LiferayServerCore.logError("Unable to determine remote freemarker debugger connection info.", (Exception)((Object)e));
            }
        }
        monitor.done();
    }

    public IServerManagerConnection getServerManagerConnection(IServer server, IProgressMonitor monitor) {
        IServerManagerConnection connection = LiferayServerCore.getRemoteConnection((IRemoteServer)server.loadAdapter(IRemoteServer.class, monitor));
        return connection;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String serverId = configuration.getAttribute(SERVER_ID, "");
        IServer server = ServerCore.findServer((String)serverId);
        if (server == null) {
            launch.terminate();
            return;
        }
        int state = server.getServerState();
        if (state != 2) {
            throw new CoreException(LiferayServerCore.createErrorStatus(Msgs.serverNotRunning));
        }
        if ("run".equals(mode)) {
            this.runLaunch(server, configuration, launch, monitor);
        } else if ("debug".equals(mode)) {
            this.debugLaunch(server, configuration, launch, monitor);
        } else {
            throw new CoreException(LiferayServerCore.createErrorStatus("Profile mode is not supported."));
        }
    }

    protected void runLaunch(IServer server, ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServerManagerConnection connection = this.getServerManagerConnection(server, monitor);
        RemoteMonitorProcess process = new RemoteMonitorProcess(server, connection, launch);
        launch.addProcess((IProcess)process);
    }

    private static class Msgs
    extends NLS {
        public static String serverNotRunning;

        static {
            Msgs.initializeMessages((String)RemoteLaunchConfigDelegate.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

