/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.LaunchHelper;
import com.liferay.ide.core.util.RuntimeClasspathModel;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;

public class PortalSupportHelper
extends LaunchHelper {
    protected File errorFile;
    protected IPath[] libRoots;
    protected File outputFile;
    protected String[] portalLibs = new String[]{"portal-impl.jar", "spring-aop.jar"};
    protected IPath portalDir;
    protected URL[] supportLibs;
    protected String[] userLibs;

    public PortalSupportHelper(IPath[] libRoots, IPath portalDir, String portalSupportClass, File outputFile, File errorFile, URL[] supportLibs, String[] userLibs) {
        this(libRoots, portalDir, portalSupportClass, outputFile, errorFile, supportLibs, userLibs, null);
    }

    public PortalSupportHelper(IPath[] libRoots, IPath portalDir, String portalSupportClass, File outputFile, File errorFile, URL[] supportLibs, String[] userLibs, String extraArg) {
        super(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        this.setLaunchSync(true);
        this.setLaunchInBackground(true);
        this.setLaunchCaptureInConsole(true);
        this.setLaunchIsPrivate(true);
        this.setMainClass(portalSupportClass);
        this.setOutputFile(outputFile);
        this.setErrorFile(errorFile);
        this.setLaunchArgs(new String[]{portalSupportClass, outputFile.getAbsolutePath(), errorFile.getAbsolutePath(), extraArg});
        this.setMode("run");
        this.libRoots = libRoots;
        this.portalDir = portalDir;
        this.userLibs = userLibs;
        this.supportLibs = supportLibs;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy config = super.createLaunchConfiguration();
        config.setContainer(null);
        config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        config.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", false);
        config.setAttribute("org.eclipse.debug.core.capture_output", false);
        config.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", true);
        return config;
    }

    public File getErrorFile() {
        return this.errorFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setErrorFile(File errorFile) {
        this.errorFile = errorFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    protected void addUserEntries(RuntimeClasspathModel model) throws CoreException {
        int n;
        int n2;
        Object[] objectArray;
        if (this.supportLibs != null && this.supportLibs.length > 0) {
            objectArray = this.supportLibs;
            n2 = this.supportLibs.length;
            n = 0;
            while (n < n2) {
                IPath supportLib = objectArray[n];
                model.addEntry(1, JavaRuntime.newStringVariableClasspathEntry((String)new Path(supportLib.getPath()).toOSString()));
                ++n;
            }
        }
        objectArray = this.libRoots;
        n2 = this.libRoots.length;
        n = 0;
        while (n < n2) {
            IPath libRoot = objectArray[n];
            Object[] libFiles = libRoot.toFile().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (!CoreUtil.isNullOrEmpty((Object[])libFiles)) {
                Object[] objectArray2 = libFiles;
                int n3 = libFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object libFile = objectArray2[n4];
                    model.addEntry(1, JavaRuntime.newStringVariableClasspathEntry((String)((File)libFile).getAbsolutePath()));
                    ++n4;
                }
            }
            ++n;
        }
        objectArray = this.portalLibs;
        n2 = this.portalLibs.length;
        n = 0;
        while (n < n2) {
            IPath portalLib = objectArray[n];
            model.addEntry(1, JavaRuntime.newStringVariableClasspathEntry((String)this.portalDir.append("WEB-INF/lib").append((String)portalLib).toOSString()));
            ++n;
        }
        if (this.userLibs != null) {
            objectArray = this.userLibs;
            n2 = this.userLibs.length;
            n = 0;
            while (n < n2) {
                IPath userLib = objectArray[n];
                model.addEntry(1, JavaRuntime.newStringVariableClasspathEntry((String)this.portalDir.append("WEB-INF/lib").append((String)userLib).toOSString()));
                ++n;
            }
        } else {
            objectArray = this.portalDir.append("WEB-INF/lib").toFile().list();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IPath jarFile = objectArray[n];
                if (jarFile.endsWith(".jar")) {
                    model.addEntry(1, JavaRuntime.newStringVariableClasspathEntry((String)this.portalDir.append("WEB-INF/lib").append((String)jarFile).toOSString()));
                }
                ++n;
            }
        }
    }
}

