/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.util.JarClassLoader;
import java.io.File;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;

public class ReleaseHelper {
    protected File serviceJarFile;
    protected JarClassLoader loader;

    public ReleaseHelper(IPath serviceJarPath) {
        if (!serviceJarPath.toFile().exists()) {
            throw new IllegalArgumentException("Service jar file must exist.");
        }
        this.serviceJarFile = serviceJarPath.toFile();
        this.loader = new JarClassLoader(this.serviceJarFile.getAbsolutePath());
    }

    public String getVersion() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String retval = null;
        try {
            Class infoClass = this.loader.loadClass("com.liferay.portal.kernel.util.ReleaseInfo");
            Object o = infoClass.newInstance();
            Method m = infoClass.getMethod("getVersion", new Class[0]);
            Object result = m.invoke(o, new Object[0]);
            if (result != null) {
                retval = result.toString();
            }
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (Throwable e) {
            LiferayServerCore.logError((Throwable)e);
        }
        return retval;
    }
}

