/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ILiferayProjectImportDataModelProperties;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.LiferayProjectImportOperation;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.osgi.framework.Version;

public class LiferayProjectImportDataModelProvider
extends FacetProjectCreationDataModelProvider
implements ILiferayProjectImportDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new LiferayProjectImportOperation(this.model);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("ILiferayProjectImportDataModelProperties.SDK_VERSION".equals(propertyName)) {
            String projectLoc = this.getStringProperty("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION");
            try {
                SDK sdk = SDKUtil.getSDKFromProjectDir((File)new File(projectLoc));
                if (sdk != null) {
                    return new Version(sdk.getVersion()).toString();
                }
            }
            catch (Exception exception) {}
        } else if ("ILiferayProjectImportDataModelProperties.PLUGIN_TYPE".equals(propertyName)) {
            return ProjectUtil.getLiferayPluginType(this.getStringProperty("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION"));
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION");
        propertyNames.add("ILiferayProjectImportDataModelProperties.PROJECT_RECORD");
        propertyNames.add("ILiferayProjectImportDataModelProperties.SDK_VERSION");
        propertyNames.add("ILiferayProjectImportDataModelProperties.PLUGIN_TYPE");
        return propertyNames;
    }

    public void init() {
        super.init();
        IFacetedProjectWorkingCopy facetedProject = this.getFacetedProjectWorkingCopy();
        facetedProject.setSelectedPreset("liferay.portlet.preset");
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        fixedFacets.add(ProjectFacetsManager.getProjectFacet((String)"liferay.ext"));
        facetedProject.setFixedProjectFacets(Collections.unmodifiableSet(fixedFacets));
        ProjectUtil.setDefaultRuntime(this.getDataModel());
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("ILiferayProjectImportDataModelProperties.SDK_VERSION".equals(propertyName) || "ILiferayProjectImportDataModelProperties.PLUGIN_TYPE".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        if ("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION".equals(name)) {
            String projectLocation = this.getStringProperty("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION");
            ProjectRecord record = ProjectUtil.getProjectRecordForDir(projectLocation);
            if (record != null) {
                String projectName = record.getProjectName();
                IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (existingProject != null && existingProject.exists()) {
                    return LiferayProjectCore.createErrorStatus((String)Msgs.projectNameExists);
                }
                File projectDir = record.getProjectLocation().toFile();
                SDK sdk = SDKUtil.getSDKFromProjectDir((File)projectDir);
                if (sdk != null) {
                    return Status.OK_STATUS;
                }
                return LiferayProjectCore.createErrorStatus((String)Msgs.projectNotLocated);
            }
            return LiferayProjectCore.createErrorStatus((String)Msgs.invalidProjectLocation);
        }
        if ("ILiferayProjectImportDataModelProperties.SDK_VERSION".equals(name)) {
            IStatus locationStatus = this.validate("ILiferayProjectImportDataModelProperties.PROJECT_LOCATION");
            if (locationStatus.isOK()) {
                Version version = new Version(this.getStringProperty("ILiferayProjectImportDataModelProperties.SDK_VERSION"));
                if (CoreUtil.compareVersions((Version)version, (Version)SDKManager.getLeastValidVersion()) >= 0) {
                    return Status.OK_STATUS;
                }
                return LiferayProjectCore.createErrorStatus((String)(String.valueOf(Msgs.invalidPluginSDKVersion) + SDKManager.getLeastValidVersion()));
            }
            return locationStatus;
        }
        if ("ILiferayProjectImportDataModelProperties.PLUGIN_TYPE".equals(name)) {
            if (ProjectUtil.isLiferayPluginType(this.getStringProperty("ILiferayProjectImportDataModelProperties.PLUGIN_TYPE"))) {
                return Status.OK_STATUS;
            }
            return LiferayProjectCore.createErrorStatus((String)Msgs.invalidLiferayPluginType);
        }
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(name)) {
            Object runtime = this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (!(runtime instanceof BridgedRuntime)) {
                return LiferayProjectCore.createErrorStatus((String)Msgs.validLiferayRuntimeSelected);
            }
            return Status.OK_STATUS;
        }
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(name)) {
            return Status.OK_STATUS;
        }
        return super.validate(name);
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    private static class Msgs
    extends NLS {
        public static String invalidLiferayPluginType;
        public static String invalidPluginSDKVersion;
        public static String invalidProjectLocation;
        public static String projectNameExists;
        public static String projectNotLocated;
        public static String validLiferayRuntimeSelected;

        static {
            Msgs.initializeMessages((String)LiferayProjectImportDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

