/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsSDKProjectRuntimeValidator
implements IFacetedProjectValidator {
    public static final String LOCATION_TARGETED_RUNTIMES = "Targeted Runtimes";
    public static final String ID_PRIMARY_RUNTIME_NOT_SET = "primary-runtime-not-set";
    public static final String ID_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME = "primary-runtime-not-liferay-runtime";
    public static final String MSG_PRIMARY_RUNTIME_NOT_SET = Msgs.primaryRuntimeNotSet;
    public static final String MSG_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME = Msgs.primaryRuntimeNotLiferayRuntime;

    public void validate(IFacetedProject fproj) throws CoreException {
        IProject proj = fproj.getProject();
        ProjectUtil.deleteProjectMarkers(proj, "com.liferay.ide.project.core.LiferayProjectMarker", this.getMarkerSourceIds());
        if (SDKUtil.isSDKProject((IProject)fproj.getProject())) {
            if (fproj.getPrimaryRuntime() == null) {
                ProjectUtil.setProjectMarker(proj, "com.liferay.ide.project.core.LiferayProjectMarker", 2, MSG_PRIMARY_RUNTIME_NOT_SET, LOCATION_TARGETED_RUNTIMES, ID_PRIMARY_RUNTIME_NOT_SET);
            } else if (!ServerUtil.isLiferayRuntime((BridgedRuntime)((BridgedRuntime)fproj.getPrimaryRuntime()))) {
                ProjectUtil.setProjectMarker(proj, "com.liferay.ide.project.core.LiferayProjectMarker", 2, MSG_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME, LOCATION_TARGETED_RUNTIMES, ID_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME);
            }
        }
    }

    private Set<String> getMarkerSourceIds() {
        HashSet<String> markerSourceIds = new HashSet<String>();
        markerSourceIds.add(ID_PRIMARY_RUNTIME_NOT_LIFERAY_RUNTIME);
        markerSourceIds.add(ID_PRIMARY_RUNTIME_NOT_SET);
        return markerSourceIds;
    }

    private static class Msgs
    extends NLS {
        public static String primaryRuntimeNotSet;
        public static String primaryRuntimeNotLiferayRuntime;

        static {
            Msgs.initializeMessages((String)PluginsSDKProjectRuntimeValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

