/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.Profile;
import com.liferay.ide.project.core.model.internal.LocationListener;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewLiferayPluginProjectOpMethods {
    public static boolean canUseCustomLocation(NewLiferayPluginProjectOp op) {
        boolean retval = false;
        if (((ILiferayProjectProvider)op.getProjectProvider().content(true)).getShortName().equals("maven")) {
            retval = true;
        } else {
            SDK sdk = SDKManager.getInstance().getSDK((String)op.getPluginsSDKName().content(true));
            if (sdk != null) {
                boolean greaterThanEqualTo6130;
                Version version = new Version(sdk.getVersion());
                boolean greaterThan611 = CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V611) > 0;
                boolean lessThan6110 = CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V6110) < 0;
                boolean bl = greaterThanEqualTo6130 = CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V6130) >= 0;
                if (greaterThan611 && lessThan6110 || greaterThanEqualTo6130) {
                    retval = true;
                }
            }
        }
        return retval;
    }

    public static final Status execute(NewLiferayPluginProjectOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay plugin project", 100);
        Status retval = null;
        try {
            ILiferayProjectProvider projectProvider = (ILiferayProjectProvider)op.getProjectProvider().content(true);
            LocationListener.updateLocation(op);
            IStatus status = projectProvider.createNewProject((Object)op, monitor);
            if (status.isOK()) {
                NewLiferayPluginProjectOpMethods.updateDefaultProjectBuildType(op);
            }
            retval = StatusBridge.create((IStatus)status);
        }
        catch (Exception e) {
            LiferayProjectCore.logError("Error creating Liferay plugin project.", e);
            return Status.createErrorStatus((String)"Error creating Liferay plugin project. Please see Eclipse error log for more details.", (Throwable)e);
        }
        return retval;
    }

    public static String getMavenParentPomVersion(NewLiferayPluginProjectOp op, String projectName, IPath path) {
        List version;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((ILiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && !(version = ((ILiferayProjectProvider)op.getProjectProvider().content()).getData("parentVersion", String.class, new Object[]{parentProjectDir})).isEmpty()) {
            retval = (String)version.get(0);
        }
        return retval;
    }

    public static String getPluginTypeSuffix(PluginType pluginType) {
        String suffix = null;
        switch (pluginType) {
            case portlet: 
            case servicebuilder: {
                suffix = "-portlet";
                break;
            }
            case ext: {
                suffix = "-ext";
                break;
            }
            case hook: {
                suffix = "-hook";
                break;
            }
            case layouttpl: {
                suffix = "-layouttpl";
                break;
            }
            case theme: {
                suffix = "-theme";
            }
        }
        return suffix;
    }

    public static Set<String> getPossibleProfileIds(NewLiferayPluginProjectOp op, boolean includeNewProfiles) {
        Object[] vals;
        String activeProfilesValue = (String)op.getActiveProfilesValue().content();
        Path currentLocation = (Path)op.getLocation().content();
        File param = currentLocation != null ? currentLocation.toFile() : null;
        List systemProfileIds = ((ILiferayProjectProvider)op.getProjectProvider().content()).getData("profileIds", String.class, new Object[]{param});
        ElementList<NewLiferayProfile> newLiferayProfiles = op.getNewLiferayProfiles();
        HashSet<String> possibleProfileIds = new HashSet<String>();
        if (!CoreUtil.isNullOrEmpty((String)activeProfilesValue) && !CoreUtil.isNullOrEmpty((Object[])(vals = activeProfilesValue.split(",")))) {
            Object[] objectArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object val = objectArray[n2];
                if (!possibleProfileIds.contains(val) && !((String)val).contains(" ")) {
                    possibleProfileIds.add((String)val);
                }
                ++n2;
            }
        }
        if (!CoreUtil.isNullOrEmpty((List)systemProfileIds)) {
            for (Object systemProfileId : systemProfileIds) {
                String val;
                if (systemProfileId == null || possibleProfileIds.contains(val = systemProfileId.toString()) || val.contains(" ")) continue;
                possibleProfileIds.add(val);
            }
        }
        if (includeNewProfiles) {
            for (NewLiferayProfile newLiferayProfile : newLiferayProfiles) {
                String newId = (String)newLiferayProfile.getId().content();
                if (CoreUtil.isNullOrEmpty((String)newId) || possibleProfileIds.contains(newId) || newId.contains(" ")) continue;
                possibleProfileIds.add(newId);
            }
        }
        return possibleProfileIds;
    }

    public static IRuntime getRuntime(NewLiferayPluginProjectOp op) {
        String runtimeName = (String)op.getRuntimeName().content(true);
        return ServerCore.findRuntime((String)runtimeName);
    }

    public static void updateActiveProfilesValue(NewLiferayPluginProjectOp op, ElementList<Profile> profiles) {
        StringBuilder sb = new StringBuilder();
        if (profiles.size() > 0) {
            for (Profile profile : profiles) {
                if (profile.getId().empty()) continue;
                sb.append((String)profile.getId().content());
                sb.append(',');
            }
        }
        op.setActiveProfilesValue(sb.toString().replaceAll("(.*),$", "$1"));
    }

    private static void updateDefaultProjectBuildType(NewLiferayPluginProjectOp op) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            prefs.put("project-default-build-type-option", op.getProjectProvider().text());
            prefs.flush();
        }
        catch (Exception e) {
            LiferayProjectCore.logError("Error updating default project build type.", e);
        }
    }

    public static void updateLocation(NewLiferayPluginProjectOp op, Path baseLocation) {
        String projectName = (String)op.getProjectName().content();
        String suffix = null;
        if ("ant".equals(((ILiferayProjectProvider)op.getProjectProvider().content(true)).getShortName()) && (suffix = NewLiferayPluginProjectOpMethods.getPluginTypeSuffix((PluginType)((Object)op.getPluginType().content(true)))) != null && projectName.endsWith(suffix)) {
            suffix = null;
        }
        String dirName = String.valueOf(projectName) + (suffix == null ? "" : suffix);
        Path newLocation = baseLocation.append(dirName);
        op.setLocation(newLocation);
    }
}

