/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class PluginsSDKNameValidationService
extends ValidationService {
    private Listener listener = null;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<Event>(){

            protected void handleTypedEvent(Event event) {
                PluginsSDKNameValidationService.this.refresh();
            }
        };
        ((NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class)).getProjectProvider().attach(this.listener);
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        NewLiferayPluginProjectOp op = (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
        if ("ant".equals(((ILiferayProjectProvider)op.getProjectProvider().content()).getShortName())) {
            String sdkName = (String)op.getPluginsSDKName().content();
            SDK sdk = SDKManager.getInstance().getSDK(sdkName);
            if (sdk == null) {
                retval = Status.createErrorStatus((String)"Plugins SDK must be configured.");
            } else if (!sdk.isValid()) {
                retval = Status.createErrorStatus((String)("Plugins SDK " + sdkName + " is invalid."));
            }
        }
        return retval;
    }

    public void dispose() {
        ((NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class)).getProjectProvider().detach(this.listener);
    }
}

