/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.DescriptorHelper;
import org.eclipse.core.resources.IProject;
import org.osgi.framework.Version;

public class LiferayDescriptorHelper
extends DescriptorHelper {
    public LiferayDescriptorHelper(IProject project) {
        super(project);
    }

    public String getDescriptorVersion() {
        String retval = null;
        try {
            ILiferayProject lProject = LiferayCore.create((Object)this.project);
            if (lProject != null) {
                String versionStr = lProject.getPortalVersion();
                retval = this.getDescriptorVersionFromPortalVersion(versionStr);
            }
        }
        catch (Exception e) {
            LiferayCore.logError((String)"Could not get liferay runtime.", (Throwable)e);
        }
        if (retval == null) {
            retval = "6.0.0";
        }
        return retval;
    }

    protected String getDescriptorVersionFromPortalVersion(String versionStr) {
        Version version = new Version(versionStr);
        int major = version.getMajor();
        int minor = version.getMinor();
        return String.valueOf(Integer.toString(major)) + "." + Integer.toString(minor) + ".0";
    }
}

