/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;

public class ServersViewDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private List dndElementList;

    public IStatus validatePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        this.initializeSelection((ISelection)aDragSelection);
        return this.internalValidate(aDropTarget, this.dndElementList);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            this.initializeSelection(s);
            return this.internalValidate(target, this.dndElementList);
        }
        return Status.CANCEL_STATUS;
    }

    protected void initializeSelection(ISelection s) {
        if (this.dndElementList != null) {
            return;
        }
        if (!(s instanceof IStructuredSelection)) {
            this.dndElementList = Collections.EMPTY_LIST;
            return;
        }
        this.dndElementList = ((IStructuredSelection)s).toList();
    }

    protected IStatus internalValidate(Object target, List elements) {
        if (target instanceof IServer) {
            IServer server = (IServer)target;
            if (elements != null) {
                for (Object next : elements) {
                    IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts(next);
                    if (moduleArtifacts == null || moduleArtifacts.length <= 0) continue;
                    int j = 0;
                    while (j < moduleArtifacts.length) {
                        IModuleType[] moduleTypes;
                        if (moduleArtifacts[j] != null && moduleArtifacts[j].getModule() != null && ServerUtil.isSupportedModule((IModuleType[])(moduleTypes = server.getServerType().getRuntimeType().getModuleTypes()), (IModuleType)moduleArtifacts[j].getModule().getModuleType())) {
                            return Status.OK_STATUS;
                        }
                        ++j;
                    }
                }
            }
        }
        this.clear();
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        IStatus status = this.internalHandleDrop(target, this.dndElementList);
        if (status.isOK()) {
            dropTargetEvent.detail = 0;
        }
        return status;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        return this.internalHandleDrop(aDropTarget, this.dndElementList);
    }

    protected IStatus internalHandleDrop(Object target, List elements) {
        boolean success = false;
        if (target instanceof IServer) {
            success = true;
            if (this.dndElementList != null) {
                for (Object data2 : elements) {
                    if (this.doRunOnServerAction((IServer)target, data2)) continue;
                    success = false;
                }
            }
        }
        this.clear();
        return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private void clear() {
        this.dndElementList = null;
    }

    protected boolean doRunOnServerAction(IServer server, Object data) {
        IModule[] modules;
        IProject project;
        IModule module = null;
        module = (IModule)Platform.getAdapterManager().getAdapter(data, IModule.class);
        if (module == null && (project = (IProject)Platform.getAdapterManager().getAdapter(data, IProject.class)) != null && (modules = ServerUtil.getModules((IProject)project)) != null && modules.length == 1) {
            module = modules[0];
        }
        if (module != null) {
            IModule[] parents;
            IServerWorkingCopy wc;
            block8: {
                block7: {
                    try {
                        wc = server.createWorkingCopy();
                        parents = wc.getRootModules(module, null);
                        if (parents != null && parents.length != 0) break block7;
                        return false;
                    }
                    catch (CoreException ce) {
                        final Shell shell = this.getShell();
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                EclipseUtil.openError(shell, ce.getLocalizedMessage());
                            }
                        });
                        return true;
                    }
                }
                if (!ServerUtil.containsModule((IServer)server, (IModule)parents[0], null)) break block8;
                PublishAction.publish(server, this.getShell());
                return false;
            }
            IModule[] add = new IModule[]{parents[0]};
            if (wc.canModifyModules(add, null, null).getSeverity() != 4) {
                wc.modifyModules(new IModule[]{module}, null, null);
                wc.save(false, null);
                PublishAction.publish(server, this.getShell());
                return true;
            }
        }
        final IServer finalServer = server;
        RunOnServerActionDelegate ros = new RunOnServerActionDelegate(){

            public IServer getServer(IModule module2, IModuleArtifact moduleArtifact, IProgressMonitor monitor) throws CoreException {
                if (!ServerUIPlugin.isCompatibleWithLaunchMode(finalServer, this.launchMode)) {
                    return null;
                }
                if (!ServerUtil.containsModule((IServer)finalServer, (IModule)module2, (IProgressMonitor)monitor)) {
                    IServerWorkingCopy wc = finalServer.createWorkingCopy();
                    ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module2}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                    wc.save(false, monitor);
                }
                return finalServer;
            }
        };
        Action action = new Action(){};
        ros.selectionChanged((IAction)action, (ISelection)new StructuredSelection(data));
        ros.run((IAction)action);
        return true;
    }
}

