/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.operation;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.DescriptorHelper;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.project.core.util.LiferayDescriptorHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutTplDescriptorHelper
extends LiferayDescriptorHelper
implements INewLayoutTplDataModelProperties {
    private static final String LAYOUT_DESCRIPTOR_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE layout-templates PUBLIC \"-//Liferay//DTD Layout Templates {0}//EN\" \"http://www.liferay.com/dtd/liferay-layout-templates_{1}.dtd\">\n\n<layout-templates>\n</layout-templates>\n";

    public LayoutTplDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addNewLayoutTemplate(final IDataModel dm) {
        IFile descriptorFile = this.getDescriptorFile("liferay-layout-templates.xml");
        DescriptorHelper.DOMModelEditOperation operation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, descriptorFile){

            protected void createDefaultFile() {
                this.createDefaultDescriptor(LayoutTplDescriptorHelper.LAYOUT_DESCRIPTOR_TEMPLATE, LayoutTplDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return LayoutTplDescriptorHelper.this.doAddLayoutTemplate(document, dm);
            }
        };
        IStatus status = operation.execute();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    public IStatus doAddLayoutTemplate(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element layoutTemplateElement = document.createElement("layout-template");
        layoutTemplateElement.setAttribute("id", model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID"));
        layoutTemplateElement.setAttribute("name", model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_NAME"));
        Node customElement = NodeUtil.getFirstNamedChildNode((Element)rootElement, (String)"custom");
        if (customElement == null) {
            Node standardElement = NodeUtil.getFirstNamedChildNode((Element)rootElement, (String)"standard");
            customElement = document.createElement("custom");
            rootElement.insertBefore(customElement, standardElement);
            NodeUtil.appendTextNode((Element)rootElement, (String)"\n");
        }
        customElement.appendChild(layoutTemplateElement);
        String templatePath = model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
        String wapTemplatePath = model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
        String thumbnailPath = model.getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE");
        NodeUtil.appendChildElement((Element)layoutTemplateElement, (String)"template-path", (String)templatePath);
        NodeUtil.appendChildElement((Element)layoutTemplateElement, (String)"wap-template-path", (String)wapTemplatePath);
        NodeUtil.appendChildElement((Element)layoutTemplateElement, (String)"thumbnail-path", (String)thumbnailPath);
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode(customElement);
        return Status.OK_STATUS;
    }

    public boolean hasTemplateId(final String templateId) {
        if (CoreUtil.isNullOrEmpty((String)templateId)) {
            return false;
        }
        final boolean[] retval = new boolean[1];
        DescriptorHelper.DOMModelReadOperation operation = new DescriptorHelper.DOMModelReadOperation((DescriptorHelper)this, this.getDescriptorFile("liferay-layout-templates.xml")){

            protected IStatus doExecute(IDOMDocument document) {
                NodeList layoutTemplates = document.getElementsByTagName("layout-template");
                if (layoutTemplates != null && layoutTemplates.getLength() > 0) {
                    int i = 0;
                    while (i < layoutTemplates.getLength()) {
                        Element layoutTemplate = (Element)layoutTemplates.item(i);
                        if (templateId.equals(layoutTemplate.getAttribute("id"))) {
                            retval[0] = true;
                            break;
                        }
                        ++i;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        operation.execute();
        return retval[0];
    }
}

