/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.operations;

import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.operations.JptFileCreationDataModelProperties;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJptFileCreationDataModelProvider
extends AbstractDataModelProvider
implements JptFileCreationDataModelProperties {
    protected AbstractJptFileCreationDataModelProvider() {
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("JptFileCreationDataModelProperties.PROJECT");
        propertyNames.add("JptFileCreationDataModelProperties.CONTAINER_PATH");
        propertyNames.add("JptFileCreationDataModelProperties.FILE_NAME");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("JptFileCreationDataModelProperties.CONTAINER_PATH")) {
            IContainer sourceLocation = this.getDefaultContainer();
            if (sourceLocation != null && sourceLocation.exists()) {
                return sourceLocation.getFullPath();
            }
        } else if (propertyName.equals("JptFileCreationDataModelProperties.FILE_NAME")) {
            return this.getDefaultFileName();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected abstract String getDefaultFileName();

    public IStatus validate(String propertyName) {
        IStatus status = Status.OK_STATUS;
        if (propertyName.equals("JptFileCreationDataModelProperties.CONTAINER_PATH") || propertyName.equals("JptFileCreationDataModelProperties.FILE_NAME")) {
            status = this.validateContainerPathAndFileName();
        }
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    protected IStatus validateContainerPathAndFileName() {
        IContainer container = this.getContainer();
        if (container == null) {
            return JptCommonCorePlugin.instance().buildErrorStatus(JptCommonCoreMessages.VALIDATE_CONTAINER_NOT_SPECIFIED);
        }
        String fileName = this.getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
        if (StringTools.isBlank((String)fileName)) {
            return JptCommonCorePlugin.instance().buildErrorStatus(JptCommonCoreMessages.VALIDATE_FILE_NAME_NOT_SPECIFIED);
        }
        if (container.getFile((IPath)new Path(fileName)).exists()) {
            return JptCommonCorePlugin.instance().buildErrorStatus(JptCommonCoreMessages.VALIDATE_FILE_ALREADY_EXISTS);
        }
        return Status.OK_STATUS;
    }

    protected IPath getContainerPath() {
        return (IPath)this.model.getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
    }

    protected IContainer getContainer() {
        IPath containerPath = this.getContainerPath();
        return containerPath == null ? null : PathTools.getContainer(containerPath);
    }

    protected IProject getProject() {
        IContainer container = this.getContainer();
        return container == null ? null : container.getProject();
    }

    protected IJavaProject getJavaProject() {
        IProject project = this.getProject();
        return project == null ? null : JavaCore.create((IProject)project);
    }

    protected IContainer getDefaultContainer() {
        IProject project = (IProject)this.model.getProperty("JptFileCreationDataModelProperties.PROJECT");
        if (project != null) {
            ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
            return locator.getDefaultLocation();
        }
        return null;
    }
}

