/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryPackageFragment;
import org.eclipse.jpt.common.core.internal.resource.java.binary.RootBinaryModel;
import org.eclipse.jpt.common.core.internal.utility.JavaElementTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragment;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryPackageFragmentRoot
extends RootBinaryModel
implements JavaResourcePackageFragmentRoot {
    private final IPackageFragmentRoot packageFragmentRoot;
    private final Vector<JavaResourcePackageFragment> packageFragments = new Vector();

    public BinaryPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot, AnnotationProvider annotationProvider) {
        super(null, annotationProvider);
        this.packageFragmentRoot = packageFragmentRoot;
        this.packageFragments.addAll(this.buildPackageFragments());
    }

    private Collection<JavaResourcePackageFragment> buildPackageFragments() {
        IJavaElement[] jdtChildren = this.getJDTChildren();
        ArrayList<JavaResourcePackageFragment> result = new ArrayList<JavaResourcePackageFragment>(jdtChildren.length);
        IJavaElement[] iJavaElementArray = jdtChildren;
        int n = jdtChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            result.add(new BinaryPackageFragment(this, (IPackageFragment)child));
            ++n2;
        }
        return result;
    }

    @Override
    public IFile getFile() {
        return (IFile)this.packageFragmentRoot.getResource();
    }

    @Override
    public void update() {
        super.update();
        this.updatePackageFragments();
    }

    private void updatePackageFragments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return IterableTools.children(this.getPackageFragments(), JavaResourcePackageFragment.TYPES_TRANSFORMER);
    }

    @Override
    public Iterable<JavaResourcePackageFragment> getPackageFragments() {
        return IterableTools.cloneLive(this.packageFragments);
    }

    @Override
    public int getPackageFragmentsSize() {
        return this.packageFragments.size();
    }

    private IJavaElement[] getJDTChildren() {
        return JavaElementTools.getChildren((IParent)this.packageFragmentRoot);
    }
}

