/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.navigator;

import com.liferay.ide.portlet.core.model.Portlet;
import com.liferay.ide.portlet.core.model.PortletApp;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import com.liferay.ide.portlet.ui.navigator.PortletNode;
import com.liferay.ide.portlet.ui.navigator.PortletResourcesRootNode;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PortletsNode {
    private static final Object[] EMPTY = new Object[0];
    private PortletApp modelElement = null;
    private PortletResourcesRootNode parent;

    public PortletsNode(PortletResourcesRootNode parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        if (this.getPortletAppModelElement() != null) {
            ArrayList<PortletNode> portletNodes = new ArrayList<PortletNode>();
            for (Portlet portlet : this.getPortletAppModelElement().getPortlets()) {
                portletNodes.add(new PortletNode(this, portlet));
            }
            return portletNodes.toArray(new PortletNode[0]);
        }
        return EMPTY;
    }

    public PortletResourcesRootNode getParent() {
        return this.parent;
    }

    private PortletApp getPortletAppModelElement() {
        IFile portletXmlFile;
        if (this.modelElement == null && (portletXmlFile = ProjectUtil.getPortletXmlFile((IProject)this.parent.getProject())) != null && portletXmlFile.exists()) {
            try {
                final IStructuredModel portletXmlModel = StructuredModelManager.getModelManager().getModelForRead(portletXmlFile);
                IModelStateListener listener = new IModelStateListener(){

                    public void modelAboutToBeChanged(IStructuredModel model) {
                    }

                    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
                    }

                    public void modelChanged(IStructuredModel model) {
                        this.refresh();
                    }

                    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
                        this.refresh();
                    }

                    public void modelReinitialized(IStructuredModel structuredModel) {
                        this.refresh();
                    }

                    public void modelResourceDeleted(IStructuredModel model) {
                        this.refresh();
                    }

                    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
                        this.refresh();
                    }

                    private void refresh() {
                        portletXmlModel.removeModelStateListener((IModelStateListener)this);
                        if (!PortletsNode.this.modelElement.disposed()) {
                            PortletsNode.this.modelElement.dispose();
                        }
                        PortletsNode.this.modelElement = null;
                        PortletsNode.this.parent.refresh();
                    }
                };
                portletXmlModel.addModelStateListener(listener);
                this.modelElement = (PortletApp)PortletApp.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(portletXmlFile.getContents())));
            }
            catch (Exception e) {
                PortletUIPlugin.logError(e);
            }
        }
        return this.modelElement;
    }

    public boolean hasChildren() {
        PortletApp model = this.getPortletAppModelElement();
        if (model != null) {
            return model.getPortlets().size() > 0;
        }
        return false;
    }
}

