/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.fm;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.debug.core.LiferayDebugCore;
import com.liferay.ide.debug.core.fm.FMDebugElement;
import com.liferay.ide.debug.core.fm.FMStackFrame;
import com.liferay.ide.debug.core.fm.FMThread;
import com.sun.jdi.Field;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import freemarker.debug.Breakpoint;
import freemarker.debug.DebuggedEnvironment;
import freemarker.debug.Debugger;
import freemarker.debug.DebuggerClient;
import freemarker.debug.DebuggerListener;
import freemarker.debug.EnvironmentSuspendedEvent;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.osgi.util.NLS;

public class FMDebugTarget
extends FMDebugElement
implements IDebugTarget,
IDebugEventSetListener,
IEclipsePreferences.IPreferenceChangeListener {
    private static final FMStackFrame[] EMPTY_STACK_FRAMES = new FMStackFrame[0];
    public static final String FM_TEMPLATE_SERVLET_CONTEXT = "_SERVLET_CONTEXT_";
    private Debugger debuggerClient;
    private EventDispatchJob eventDispatchJob;
    private FMStackFrame[] fmStackFrames = EMPTY_STACK_FRAMES;
    private FMThread fmThread;
    private String host;
    private ILaunch launch;
    private String name;
    private IProcess process;
    private boolean suspended = false;
    private FMDebugTarget target;
    private boolean terminated = false;
    private IThread[] threads = new IThread[0];

    public FMDebugTarget(String host, ILaunch launch, IProcess process) {
        super(null);
        this.target = this;
        this.host = host;
        this.launch = launch;
        this.process = process;
        this.fmThread = new FMThread(this.target);
        this.eventDispatchJob = new EventDispatchJob();
        this.eventDispatchJob.schedule();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        LiferayDebugCore.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void addRemoteBreakpoints(final Debugger debugger, IBreakpoint[] bps) throws RemoteException {
        final ArrayList<Breakpoint> remoteBps = new ArrayList<Breakpoint>();
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            int line = bp.getMarker().getAttribute("lineNumber", -1);
            String templateName = bp.getMarker().getAttribute("templateName", null);
            String remoteTemplateName = this.createRemoteTemplateName(templateName);
            if (!CoreUtil.isNullOrEmpty((String)remoteTemplateName) && line > -1) {
                remoteBps.add(new Breakpoint(remoteTemplateName, line));
            }
            ++n2;
        }
        Job job = new Job("add remote breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus retval = null;
                for (Breakpoint bp : remoteBps) {
                    try {
                        debugger.addBreakpoint(bp);
                    }
                    catch (RemoteException e) {
                        retval = LiferayDebugCore.createErrorStatus(NLS.bind((String)"Could not add remote breakpoint: {0}:{1}", (Object[])new Object[]{bp.getTemplateName(), bp.getLine()}), e);
                        if (retval == Status.OK_STATUS) continue;
                        LiferayDebugCore.logError(retval.getMessage());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint) && !this.launch.isTerminated()) {
            try {
                Debugger debugger = this.getDebuggerClient();
                if (debugger != null && breakpoint.isEnabled()) {
                    this.addRemoteBreakpoints(debugger, new IBreakpoint[]{breakpoint});
                }
            }
            catch (Exception e) {
                LiferayDebugCore.logError("Error adding breakpoint.", e);
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint) && !this.launch.isTerminated()) {
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint) && !this.launch.isTerminated()) {
            this.removeRemoteBreakpoints(new IBreakpoint[]{breakpoint});
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean canTerminate() {
        return false;
    }

    private void cleanup() {
        this.terminated = true;
        this.suspended = false;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        LiferayDebugCore.getPrefs().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private String createRemoteTemplateName(String templateName) {
        String retval = null;
        if (!CoreUtil.isNullOrEmpty((String)templateName)) {
            Path templatePath = new Path(templateName);
            String firstSegment = templatePath.segment(0);
            IProject project = CoreUtil.findProjectByContextName((String)firstSegment);
            if (project != null) {
                Object[] bindings = new Object[]{firstSegment, FM_TEMPLATE_SERVLET_CONTEXT, templatePath.removeFirstSegments(1)};
                retval = NLS.bind((String)"{0}{1}/{2}", (Object[])bindings);
            } else {
                retval = templatePath.toPortableString();
            }
        }
        return retval;
    }

    public void disconnect() throws DebugException {
    }

    public Debugger getDebuggerClient() {
        if (this.debuggerClient == null) {
            try {
                this.debuggerClient = DebuggerClient.getDebugger((InetAddress)Inet4Address.getByName(this.host), (int)this.getDebugPort(), (String)this.getDebugPassword());
            }
            catch (Exception exception) {}
        }
        return this.debuggerClient;
    }

    private String getDebugPassword() {
        String debugPassword = this.launch.getAttribute("fm-debug-password");
        if (debugPassword != null) {
            return debugPassword;
        }
        return LiferayDebugCore.getPreference("fm-debug-password");
    }

    private int getDebugPort() {
        String debugPort = this.launch.getAttribute("fm-debug-port");
        if (debugPort != null) {
            return Integer.parseInt(debugPort);
        }
        return Integer.parseInt(LiferayDebugCore.getPreference("fm-debug-port"));
    }

    public FMDebugTarget getDebugTarget() {
        return this.target;
    }

    private String getDisplayableTemplateName(String templateName) {
        return templateName.replaceAll(FM_TEMPLATE_SERVLET_CONTEXT, "");
    }

    private ILineBreakpoint[] getEnabledLineBreakpoints() {
        ArrayList<ILineBreakpoint> breakpoints = new ArrayList<ILineBreakpoint>();
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (breakpointManager.isEnabled()) {
            IBreakpoint[] fmBreakpoints;
            IBreakpoint[] iBreakpointArray = fmBreakpoints = breakpointManager.getBreakpoints(this.getModelIdentifier());
            int n = fmBreakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint fmBreakpoint = iBreakpointArray[n2];
                try {
                    if (fmBreakpoint instanceof ILineBreakpoint && this.supportsBreakpoint(fmBreakpoint) && fmBreakpoint.isEnabled()) {
                        breakpoints.add((ILineBreakpoint)fmBreakpoint);
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        }
        return breakpoints.toArray(new ILineBreakpoint[0]);
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            this.name = "Freemarker Debugger at " + this.host + ":" + this.getDebugPort();
        }
        return this.name;
    }

    public IProcess getProcess() {
        return this.process;
    }

    FMStackFrame[] getStackFrames() {
        return this.fmStackFrames;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && this.process.equals(event.getSource()) && this.process.isTerminated()) {
                this.cleanup();
            }
            ++n2;
        }
    }

    public boolean hasThreads() throws DebugException {
        return this.threads != null && this.threads.length > 0;
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isTerminated() {
        return this.terminated || this.getProcess().isTerminated();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("advanced-variables-view".equals(event.getKey())) {
            FMStackFrame[] fMStackFrameArray = this.getStackFrames();
            int n = fMStackFrameArray.length;
            int n2 = 0;
            while (n2 < n) {
                FMStackFrame stackFrame = fMStackFrameArray[n2];
                stackFrame.clearVariables();
                ++n2;
            }
        }
    }

    private void removeRemoteBreakpoints(IBreakpoint[] breakpoints) {
        final ArrayList<Breakpoint> remoteBreakpoints = new ArrayList<Breakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            String templateName = bp.getMarker().getAttribute("templateName", "");
            String remoteTemplateName = this.createRemoteTemplateName(templateName);
            Breakpoint remoteBp = new Breakpoint(remoteTemplateName, bp.getMarker().getAttribute("lineNumber", -1));
            remoteBreakpoints.add(remoteBp);
            ++n2;
        }
        Job job = new Job("remove remote breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus retval = null;
                for (Breakpoint bp : remoteBreakpoints) {
                    try {
                        FMDebugTarget.this.getDebuggerClient().removeBreakpoint(bp);
                    }
                    catch (Exception e) {
                        retval = LiferayDebugCore.createErrorStatus(NLS.bind((String)"Unable to get debug client to remove breakpoint: {0}:{1}", (Object[])new Object[]{bp.getTemplateName(), bp.getLine()}), e);
                        if (retval == Status.OK_STATUS) continue;
                        LiferayDebugCore.logError(retval.getMessage());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void resume() {
        Job job = new Job("resume"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Debugger debugger = FMDebugTarget.this.getDebuggerClient();
                    if (debugger != null) {
                        if (FMDebugTarget.this.fmThread.isStepping()) {
                            Breakpoint stepBp = FMDebugTarget.this.fmThread.getStepBreakpoint();
                            debugger.removeBreakpoint(stepBp);
                        }
                        for (DebuggedEnvironment env : debugger.getSuspendedEnvironments()) {
                            try {
                                env.resume();
                            }
                            catch (Exception e) {
                                LiferayDebugCore.logError("Could not resume suspended environment", e);
                            }
                        }
                        FMDebugTarget.this.fmStackFrames = EMPTY_STACK_FRAMES;
                        FMDebugTarget.this.resumed(32);
                    }
                }
                catch (RemoteException e) {
                    LiferayDebugCore.logError("Could not fully resume suspended environments", e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void resume(FMThread thread) throws DebugException {
        try {
            Breakpoint stepBp = thread.getStepBreakpoint();
            if (stepBp != null) {
                this.getDebuggerClient().removeBreakpoint(stepBp);
                thread.setStepping(false);
                thread.setStepBreakpoint(null);
            }
            thread.getEnvironment().resume();
            this.fmStackFrames = EMPTY_STACK_FRAMES;
            this.resumed(32);
        }
        catch (RemoteException e) {
            throw new DebugException(LiferayDebugCore.createErrorStatus(e));
        }
    }

    private void resumed(int detail) {
        this.suspended = false;
        this.fmStackFrames = EMPTY_STACK_FRAMES;
        this.fmThread.fireResumeEvent(detail);
        this.fireResumeEvent(detail);
    }

    void step(FMThread thread) throws DebugException {
        block15: {
            int currentLineNumber = -1;
            String templateName = null;
            Breakpoint existingStepBp = null;
            IBreakpoint[] breakpoints = thread.getBreakpoints();
            if (breakpoints.length > 0) {
                try {
                    ILineBreakpoint bp = (ILineBreakpoint)breakpoints[0];
                    currentLineNumber = bp.getLineNumber();
                    templateName = bp.getMarker().getAttribute("templateName", "");
                }
                catch (CoreException e) {
                    LiferayDebugCore.logError("Could not get breakpoint information.", (Exception)((Object)e));
                }
            } else {
                existingStepBp = thread.getStepBreakpoint();
                currentLineNumber = existingStepBp.getLine();
                templateName = existingStepBp.getTemplateName();
            }
            if (currentLineNumber > -1 && templateName != null) {
                String remoteTemplateName = this.createRemoteTemplateName(templateName);
                int stepLine = currentLineNumber + 1;
                Breakpoint existingBp = null;
                Debugger debugCli = this.getDebuggerClient();
                try {
                    List remoteBps = debugCli.getBreakpoints(remoteTemplateName);
                    for (Breakpoint remoteBp : remoteBps) {
                        if (remoteBp.getLine() != stepLine) continue;
                        existingBp = remoteBp;
                        break;
                    }
                    if (existingBp == null) {
                        boolean addedRemote = false;
                        while (!addedRemote) {
                            Breakpoint newBp = new Breakpoint(remoteTemplateName, stepLine++);
                            try {
                                debugCli.addBreakpoint(newBp);
                            }
                            catch (RemoteException remoteException) {}
                            List updatedRemoteBps = debugCli.getBreakpoints(remoteTemplateName);
                            if (updatedRemoteBps.size() != remoteBps.size() + 1) continue;
                            addedRemote = true;
                            thread.setStepBreakpoint(newBp);
                            thread.setStepping(true);
                            this.fireResumeEvent(1);
                            if (existingStepBp != null) {
                                debugCli.removeBreakpoint(existingStepBp);
                            }
                            thread.getEnvironment().resume();
                        }
                        break block15;
                    }
                    thread.setStepBreakpoint(null);
                    thread.setStepping(false);
                    this.fireResumeEvent(1);
                    if (existingStepBp != null) {
                        debugCli.removeBreakpoint(existingStepBp);
                    }
                    thread.getEnvironment().resume();
                }
                catch (RemoteException e) {
                    LiferayDebugCore.logError("Unable to check remote breakpoints", e);
                }
            } else {
                LiferayDebugCore.logError("Unable to step because of missing lineNumber or templateName information.");
            }
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals("com.liferay.ide.debug.freemarker")) {
            try {
                return breakpoint.getMarker().getType().equals("com.liferay.ide.debug.core.fmLineBreakpointMarker");
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public void suspend() throws DebugException {
    }

    private void suspended(int detail) {
        this.suspended = true;
        this.fmThread.fireSuspendEvent(detail);
    }

    boolean suspendRelatedJavaThread(long remoteThreadId) throws DebugException {
        boolean retval = false;
        IDebugTarget[] iDebugTargetArray = this.launch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            if (target instanceof IJavaDebugTarget) {
                IThread[] threads;
                IJavaDebugTarget javaTarget = (IJavaDebugTarget)target;
                IThread[] iThreadArray = threads = javaTarget.getThreads();
                int n3 = threads.length;
                int n4 = 0;
                while (n4 < n3) {
                    Field tidField;
                    JDIThread jdiThread;
                    ThreadReference underlyingThread;
                    Value tidValue;
                    long threadId;
                    IThread thread = iThreadArray[n4];
                    if (thread instanceof JDIThread && (threadId = Long.parseLong((tidValue = (underlyingThread = (jdiThread = (JDIThread)thread).getUnderlyingThread()).getValue(tidField = underlyingThread.referenceType().fieldByName("tid"))).toString())) == remoteThreadId) {
                        thread.suspend();
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return retval;
    }

    public void terminate() throws DebugException {
        ILineBreakpoint[] localBreakpoints = this.getEnabledLineBreakpoints();
        this.removeRemoteBreakpoints((IBreakpoint[])localBreakpoints);
        this.resume();
        this.terminated();
    }

    private void terminated() {
        this.cleanup();
        this.fireTerminateEvent();
    }

    class EventDispatchJob
    extends Job
    implements DebuggerListener {
        private boolean setup;

        public EventDispatchJob() {
            super("Freemarker Event Dispatch");
            this.setSystem(true);
        }

        public void environmentSuspended(EnvironmentSuspendedEvent event) throws RemoteException {
            Breakpoint stepBp;
            int lineNumber = event.getLine();
            ILineBreakpoint[] breakpoints = FMDebugTarget.this.getEnabledLineBreakpoints();
            boolean foundBreakpoint = false;
            ILineBreakpoint[] iLineBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                ILineBreakpoint breakpoint = iLineBreakpointArray[n2];
                if (breakpoint instanceof ILineBreakpoint) {
                    ILineBreakpoint lineBreakpoint = breakpoint;
                    try {
                        int bpLineNumber = lineBreakpoint.getLineNumber();
                        String templateName = breakpoint.getMarker().getAttribute("templateName", "");
                        String remoteTemplateName = event.getTemplateName().replaceAll(FMDebugTarget.FM_TEMPLATE_SERVLET_CONTEXT, "");
                        if (bpLineNumber == lineNumber && remoteTemplateName.equals(templateName)) {
                            String frameName = String.valueOf(templateName) + " line: " + lineNumber;
                            FMDebugTarget.this.fmThread.setEnvironment(event.getEnvironment());
                            FMDebugTarget.this.fmThread.setThreadId(event.getThreadId());
                            FMDebugTarget.this.fmThread.setBreakpoints(new IBreakpoint[]{breakpoint});
                            FMDebugTarget.this.fmStackFrames = new FMStackFrame[]{new FMStackFrame(FMDebugTarget.this.fmThread, frameName)};
                            foundBreakpoint = true;
                            break;
                        }
                    }
                    catch (CoreException e) {
                        LiferayDebugCore.logError("Unable to suspend at breakpoint", (Exception)((Object)e));
                    }
                }
                ++n2;
            }
            if (!foundBreakpoint && FMDebugTarget.this.fmThread.isStepping() && (stepBp = FMDebugTarget.this.fmThread.getStepBreakpoint()) != null) {
                String frameName = String.valueOf(FMDebugTarget.this.getDisplayableTemplateName(stepBp.getTemplateName())) + " line: " + stepBp.getLine();
                FMDebugTarget.this.fmThread.setEnvironment(event.getEnvironment());
                FMDebugTarget.this.fmThread.setBreakpoints(null);
                FMDebugTarget.this.fmThread.setStepping(false);
                FMDebugTarget.this.fmStackFrames = new FMStackFrame[]{new FMStackFrame(FMDebugTarget.this.fmThread, frameName)};
                foundBreakpoint = true;
            }
            if (foundBreakpoint) {
                FMDebugTarget.this.suspended(16);
            } else {
                new Job("resuming remote environment"){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus retval = Status.OK_STATUS;
                        try {
                            for (DebuggedEnvironment e : FMDebugTarget.this.getDebuggerClient().getSuspendedEnvironments()) {
                                e.resume();
                            }
                        }
                        catch (RemoteException e) {
                            retval = LiferayDebugCore.createErrorStatus("Could not resume after missing breakpoint", e);
                        }
                        return retval;
                    }
                }.schedule();
                LiferayDebugCore.logError("Could not find local breakpoint, resuming all remote environments");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!FMDebugTarget.this.isTerminated()) {
                Debugger debugger = FMDebugTarget.this.getDebuggerClient();
                if (debugger == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (!this.setup) {
                    this.setup = this.setupDebugger(debugger);
                }
                EventDispatchJob eventDispatchJob = FMDebugTarget.this.eventDispatchJob;
                synchronized (eventDispatchJob) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return Status.OK_STATUS;
        }

        private boolean setupDebugger(Debugger debugger) {
            try {
                debugger.addDebuggerListener((DebuggerListener)FMDebugTarget.this.eventDispatchJob);
                FMDebugTarget.this.threads = new IThread[]{FMDebugTarget.this.fmThread};
                ILineBreakpoint[] localBreakpoints = FMDebugTarget.this.getEnabledLineBreakpoints();
                FMDebugTarget.this.addRemoteBreakpoints(debugger, (IBreakpoint[])localBreakpoints);
            }
            catch (RemoteException remoteException) {
                return false;
            }
            return true;
        }
    }
}

