/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.fm;

import com.liferay.ide.core.util.CoreUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FMLineBreakpoint
extends LineBreakpoint {
    public FMLineBreakpoint() {
    }

    public FMLineBreakpoint(final IResource resource, final int line) throws CoreException {
        final String templateName = FMLineBreakpoint.getTemplateName(resource);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            private String createMessage(String templateName2) {
                return "Freemarker breakpoint: " + templateName2 + " [line: " + line + "]";
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.liferay.ide.debug.core.fmLineBreakpointMarker");
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", line);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)FMLineBreakpoint.this.getModelIdentifier());
                marker.setAttribute("templateName", (Object)templateName);
                marker.setAttribute("message", (Object)this.createMessage(templateName));
                FMLineBreakpoint.this.setMarker(marker);
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    private static String getTemplateName(IResource resource) {
        String retval = null;
        IProject project = resource.getProject();
        if (project != null && CoreUtil.isLiferayProject((IProject)project)) {
            IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)true);
            String contextRoot = String.valueOf(c.getMetaProperties().getProperty("context-root")) + "/";
            IContainer[] iContainerArray = c.getRootFolder().getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath fileFullPath;
                IContainer parentFolder = iContainerArray[n2];
                IPath parentFullPath = parentFolder.getFullPath();
                if (parentFullPath.isPrefixOf(fileFullPath = resource.getFullPath())) {
                    IPath relativePath = fileFullPath.makeRelativeTo(parentFullPath);
                    String relativePathValue = relativePath.toPortableString();
                    if (relativePathValue.startsWith("_diffs/")) {
                        retval = String.valueOf(contextRoot) + relativePathValue.substring("_diffs/".length(), relativePathValue.length());
                        break;
                    }
                    retval = String.valueOf(contextRoot) + relativePathValue;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    public String getModelIdentifier() {
        return "com.liferay.ide.debug.freemarker";
    }
}

