/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.debug.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static String extract(String string, String beginDelimiter, String endDelimiter) {
        return StringUtil.extract(string, beginDelimiter, endDelimiter, 0);
    }

    public static String extract(String string, String beginDelimiter, String endDelimiter, int fromIndex) {
        if (StringUtil.isNull(string) || beginDelimiter == null || beginDelimiter.isEmpty()) {
            return "";
        }
        int beginIndex = string.indexOf(beginDelimiter) + beginDelimiter.length();
        int endIndex = string.length();
        if (endDelimiter != null || !endDelimiter.isEmpty()) {
            endIndex = string.indexOf(endDelimiter);
        }
        if (beginIndex >= endIndex) {
            return "";
        }
        return string.substring(beginIndex, endIndex);
    }

    public static boolean isNotNull(String string) {
        return !StringUtil.isNull(string);
    }

    public static boolean isNull(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        return (string = string.trim()).isEmpty();
    }

    public static List<String> split(String string) {
        return StringUtil.split(string, ",");
    }

    public static List<String> split(String string, String delimiter) {
        String nodeValue;
        if (StringUtil.isNull(string) || delimiter == null || delimiter.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = string.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValue = string.substring(offset, pos);
            if (!(nodeValue = nodeValue.trim()).isEmpty()) {
                nodeValues.add(nodeValue);
            }
            offset = pos + 1;
            pos = string.indexOf(delimiter, offset);
        }
        if (offset < string.length()) {
            nodeValue = string.substring(offset);
            if (!(nodeValue = nodeValue.trim()).isEmpty()) {
                nodeValues.add(nodeValue);
            }
        }
        return nodeValues;
    }

    public static String replace(String string, String oldSub, String newSub) {
        return StringUtil.replace(string, oldSub, newSub, 0);
    }

    public static String replace(String string, String oldSub, String newSub, int fromIndex) {
        int y;
        if (string == null) {
            return null;
        }
        if (oldSub == null || oldSub.equals("")) {
            return string;
        }
        if (newSub == null) {
            newSub = "";
        }
        if ((y = string.indexOf(oldSub, fromIndex)) < 0) {
            return string;
        }
        StringBuilder sb = new StringBuilder();
        int length = oldSub.length();
        int x = 0;
        while (x <= y) {
            sb.append(string.substring(x, y));
            sb.append(newSub);
            x = y + length;
            y = string.indexOf(oldSub, x);
        }
        sb.append(string.substring(x));
        return sb.toString();
    }
}

