/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui;

import com.liferay.ide.ui.LiferayDefaultCodeFormatterSettings;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class LiferayUIPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String FIRST_STARTUP_COMPLETE = "FIRST_STARTUP_COMPLETE";
    public static final String IMG_LIFERAY_ICON_SMALL = "IMG_LIFERAY_ICON_SMALL";
    public static final String PLUGIN_ID = "com.liferay.ide.ui";
    private static LiferayUIPlugin plugin;
    protected TextFileDocumentProvider fTextFileDocumentProvider;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();

    public static void clearAllPersistentSettings() throws BackingStoreException {
        IEclipsePreferences tomcatCorePrefs = new InstanceScope().getNode("com.liferay.ide.server.tomcat.core");
        tomcatCorePrefs.remove("ADDED_EXT_PLUGIN_TOGGLE_KEY");
        tomcatCorePrefs.remove("ADDED_EXT_PLUGIN_WITHOUT_ZIP_TOGGLE_KEY");
        tomcatCorePrefs.remove("REMOVE_EXT_PLUGIN_TOGGLE_KEY");
        tomcatCorePrefs.flush();
    }

    public static IStatus createErrorStatus(String string) {
        return new Status(4, PLUGIN_ID, string);
    }

    public static void logError(String msg, Exception e) {
        LiferayUIPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static LiferayUIPlugin getDefault() {
        return plugin;
    }

    public static Map getLiferaySettings() {
        Map options = new DefaultCodeFormatterOptions(LiferayDefaultCodeFormatterSettings.settings).getMap();
        ProfileVersioner.setLatestCompliance((Map)options);
        return options;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void logError(Exception e) {
        LiferayUIPlugin.logError(e.getMessage(), e);
    }

    public void earlyStartup() {
        if (this.isFirstStartup()) {
            this.installLiferayFormatterProfile();
            this.firstStartupComplete();
        }
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        this.getImageRegistry();
        return this.imageDescriptors.get(key);
    }

    public synchronized IDocumentProvider getTextFileDocumentProvider() {
        if (this.fTextFileDocumentProvider == null) {
            this.fTextFileDocumentProvider = new TextFileDocumentProvider();
        }
        return this.fTextFileDocumentProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void firstStartupComplete() {
        this.getPreferences().putBoolean(FIRST_STARTUP_COMPLETE, true);
    }

    private IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    private void installLiferayFormatterProfile() {
        block12: {
            PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
            ProfileVersioner profileVersioner = new ProfileVersioner();
            IScopeContext instanceScope = access.getInstanceScope();
            try {
                try {
                    FormatterProfileStore store = new FormatterProfileStore((IProfileVersioner)profileVersioner);
                    ArrayList<ProfileManager.CustomProfile> profiles = store.readProfiles(instanceScope);
                    if (profiles == null) {
                        profiles = new ArrayList<ProfileManager.CustomProfile>();
                    }
                    ProfileManager.CustomProfile eclipseProfile = new ProfileManager.CustomProfile("Liferay [plug-in]", LiferayUIPlugin.getLiferaySettings(), profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
                    profiles.add(eclipseProfile);
                    store.writeProfiles(profiles, instanceScope);
                    instanceScope.getNode("org.eclipse.jdt.ui").flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        instanceScope.getNode("org.eclipse.jdt.core").flush();
                    }
                    catch (BackingStoreException backingStoreException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    instanceScope.getNode("org.eclipse.jdt.core").flush();
                }
                catch (BackingStoreException backingStoreException) {}
                throw throwable;
            }
            try {
                instanceScope.getNode("org.eclipse.jdt.core").flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private boolean isFirstStartup() {
        IScopeContext[] scopes = new IScopeContext[]{new InstanceScope()};
        return !Platform.getPreferencesService().getBoolean(PLUGIN_ID, FIRST_STARTUP_COMPLETE, false, scopes);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.registerImage(reg, IMG_LIFERAY_ICON_SMALL, "/icons/e16/liferay.png");
    }

    protected void registerImage(ImageRegistry registry, String key, String path) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry(path));
            this.imageDescriptors.put(key, id);
            registry.put(key, id);
        }
        catch (Exception exception) {}
    }
}

