/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.AbstractProjectBuilder;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectBuilder
extends AbstractProjectBuilder {
    protected final IMaven maven = MavenPlugin.getMaven();
    protected final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    public MavenProjectBuilder(IProject project) {
        super(project);
    }

    public IStatus buildLang(IFile langFile, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(Msgs.buildingLanguages, 100);
        final IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), (IProgressMonitor)sub);
        sub.worked(10);
        ICallable<IStatus> callable = new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return MavenUtil.executeMojoGoal(facade, context, "liferay:build-lang", monitor);
            }
        };
        IStatus retval = this.executeMaven(facade, callable, (IProgressMonitor)sub);
        sub.worked(80);
        this.getProject().refreshLocal(2, (IProgressMonitor)sub);
        sub.worked(10);
        sub.done();
        return retval;
    }

    public IStatus buildSB(IFile serviceXmlFile, final String goal, IProgressMonitor monitor) throws CoreException {
        final IMavenProjectFacade facade = MavenUtil.getProjectFacade(this.getProject(), monitor);
        monitor.worked(10);
        ICallable<IStatus> callable = new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return MavenUtil.executeMojoGoal(facade, context, goal, monitor);
            }
        };
        IStatus retval = this.executeMaven(facade, callable, monitor);
        monitor.worked(70);
        this.refreshSiblingProject(facade, monitor);
        monitor.worked(10);
        this.getProject().refreshLocal(2, monitor);
        monitor.worked(10);
        monitor.done();
        return retval;
    }

    public IStatus buildService(IFile serviceXmlFile, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(Msgs.buildingServices, 100);
        return this.buildSB(serviceXmlFile, "liferay:build-service", (IProgressMonitor)sub);
    }

    public IStatus buildWSDD(IFile serviceXmlFile, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(Msgs.buildingWSDD, 100);
        return this.buildSB(serviceXmlFile, "liferay:build-wsdd", (IProgressMonitor)sub);
    }

    protected IStatus executeMaven(final IMavenProjectFacade projectFacade, final ICallable<IStatus> callable, IProgressMonitor monitor) throws CoreException {
        return (IStatus)this.maven.execute((ICallable)new ICallable<IStatus>(){

            public IStatus call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return (IStatus)MavenProjectBuilder.this.projectManager.execute(projectFacade, callable, monitor);
            }
        }, monitor);
    }

    public void refreshSiblingProject(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        try {
            Plugin liferayMavenPlugin = MavenUtil.getLiferayMavenPlugin(projectFacade.getMavenProject());
            Xpp3Dom config = (Xpp3Dom)liferayMavenPlugin.getConfiguration();
            Xpp3Dom apiBaseDir = config.getChild("apiBaseDir");
            String apiBaseDirValue = apiBaseDir.getValue();
            IFile apiBasePomFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(new Path(apiBaseDirValue).append("pom.xml"));
            IMavenProjectFacade apiBaseFacade = this.projectManager.create(apiBasePomFile, true, monitor);
            apiBaseFacade.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            LiferayMavenCore.logError("Could not refresh sibling service project.", e);
        }
    }

    protected static class Msgs
    extends NLS {
        public static String buildingLanguages;
        public static String buildingServices;
        public static String buildingWSDD;

        static {
            Msgs.initializeMessages((String)MavenProjectBuilder.class.getName(), Msgs.class);
        }

        protected Msgs() {
        }
    }
}

