/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.concurrency;

import io.tesla.aether.concurrency.LockingSyncContext;
import io.tesla.filelock.FileLockManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;

@Component(role=SyncContextFactory.class)
public class LockingSyncContextFactory
implements SyncContextFactory,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private FileLockManager fileLockManager;

    public LockingSyncContextFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public LockingSyncContextFactory setFileLockManager(FileLockManager fileLockManager) {
        this.fileLockManager = fileLockManager;
        return this;
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setFileLockManager((FileLockManager)locator.getService(FileLockManager.class));
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new LockingSyncContext(shared, session, this.fileLockManager, this.logger);
    }
}

