/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.ivyfile;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class IvyFileResourceListener
implements IResourceChangeListener {
    private static final IResourceDeltaVisitor VISITOR = new IvyVisitor();

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 8) {
            try {
                event.getDelta().accept(VISITOR);
            }
            catch (CoreException e) {
                IvyPlugin.log(e);
            }
        }
    }

    private static class IvyVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private IvyVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            IvyVisitor.resourceChanged(resource);
            return true;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (4 == delta.getKind() && (delta.getFlags() & 0x100) == 256) {
                IvyVisitor.resourceChanged(resource);
            }
            return true;
        }

        private static void resourceChanged(IResource resource) {
            if (!(resource instanceof IFile) || !IvyPlugin.getPreferenceStoreHelper().getAutoResolveOnChange()) {
                return;
            }
            IFile resourceFile = (IFile)resource;
            IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
            if (javaProject == null) {
                return;
            }
            List containers = IvyClasspathContainerHelper.getContainers(javaProject);
            Iterator containerIter = containers.iterator();
            while (containerIter.hasNext()) {
                IvyClasspathContainerImpl container = (IvyClasspathContainerImpl)containerIter.next();
                try {
                    File containerIvyFile = container.getState().getIvyFile();
                    if (!containerIvyFile.equals(resourceFile.getLocation().toFile())) continue;
                    container.launchResolve(false, null);
                    return;
                }
                catch (IvyDEException ivyDEException) {}
            }
        }
    }
}

