/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse;

import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class IvyDEException
extends Exception {
    private final String shortMsg;
    private String msg;

    public IvyDEException(String shortMsg, String msg, Throwable cause) {
        super(cause);
        this.shortMsg = shortMsg;
        this.msg = msg;
    }

    public String getShortMsg() {
        return this.shortMsg;
    }

    public String getMessage() {
        return this.msg;
    }

    public void contextualizeMessage(String context) {
        this.msg = String.valueOf(context) + ":\n  " + this.msg;
    }

    public void show(final int status, final String title, String preMsg) {
        final String msg = String.valueOf(preMsg == null ? "" : String.valueOf(preMsg) + "\n\n") + this.getMessage() + (this.getCause() == null ? "" : "\n\nUnderlying error (" + this.getCause().getClass().getName() + "): " + this.getCause().getMessage());
        IvyPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                switch (status) {
                    case 4: {
                        MessageDialog.openError((Shell)IvyPlugin.getActiveWorkbenchShell(), (String)title, (String)msg);
                        return;
                    }
                    case 2: {
                        MessageDialog.openWarning((Shell)IvyPlugin.getActiveWorkbenchShell(), (String)title, (String)msg);
                        return;
                    }
                    case 1: {
                        MessageDialog.openInformation((Shell)IvyPlugin.getActiveWorkbenchShell(), (String)title, (String)msg);
                        return;
                    }
                }
                IvyPlugin.logWarn("Unsupported IvyDE error status: " + status);
            }
        });
    }

    public void log(int status, String preMsg) {
        String msg = String.valueOf(preMsg == null ? "" : preMsg) + this.getMessage();
        IvyPlugin.log(status, msg, this.getCause());
    }

    public IStatus asStatus(int status, String preMsg) {
        String msg = String.valueOf(preMsg == null ? "" : preMsg) + this.getMessage();
        return new Status(status, "org.apache.ivyde.eclipse", 0, msg, (Throwable)this);
    }

    public void print(int status, String preMsg) {
        String msg = String.valueOf(preMsg == null ? "" : preMsg) + this.getMessage();
        switch (status) {
            case 4: {
                IvyDEMessage.error(msg);
                return;
            }
            case 2: 
            case 8: {
                IvyDEMessage.warn(msg);
                return;
            }
            case 0: 
            case 1: {
                IvyDEMessage.info(msg);
                return;
            }
        }
        IvyPlugin.logWarn("Unsupported IvyDE error status: " + status);
    }
}

