/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;

public final class IvyClasspathUtil {
    private IvyClasspathUtil() {
    }

    public static IvyClasspathContainerImpl jdt2IvyCPC(ClassPathContainer cpc) {
        IClasspathEntry entry = cpc.getClasspathEntry();
        try {
            IClasspathContainer icp = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)cpc.getJavaProject());
            if (icp instanceof IvyClasspathContainerImpl) {
                return (IvyClasspathContainerImpl)icp;
            }
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
        }
        return null;
    }

    public static List split(String str) {
        String[] terms = str.split(",");
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < terms.length) {
            String t = terms[i].trim();
            if (t.length() > 0) {
                ret.add(t);
            }
            ++i;
        }
        return ret;
    }

    public static String concat(Collection list) {
        if (list == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append(",");
        }
        return b.toString();
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                try {
                    return new URL(attrib.getValue());
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public static void toIvyFile(ModuleDescriptor descriptor, IvyClasspathContainerImpl container) throws ParseException, IOException, IvyDEException {
        IvyClasspathContainerConfiguration conf = container.getConf();
        IFile ivyFile = conf.getJavaProject().getProject().getFile(conf.getIvyXmlPath());
        IStatus writable = ivyFile.getWorkspace().validateEdit(new IFile[]{ivyFile}, IWorkspace.VALIDATE_PROMPT);
        if (writable.isOK()) {
            descriptor.toIvyFile(container.getState().getIvyFile());
        }
    }

    public static String buildResolveId(boolean useExtendedResolveId, ModuleDescriptor md) {
        StringBuffer sb = new StringBuffer(ResolveOptions.getDefaultResolveId((ModuleDescriptor)md));
        if (useExtendedResolveId) {
            ModuleRevisionId mrid = md.getModuleRevisionId();
            String sts = md.getStatus();
            String bch = mrid.getBranch();
            String rev = mrid.getRevision();
            sb.append("-");
            if (sts != null) {
                sb.append(sts);
            }
            sb.append("-");
            if (bch != null) {
                sb.append(bch);
            }
            sb.append("-");
            if (rev != null) {
                sb.append(rev);
            }
        }
        return sb.toString();
    }
}

